/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineUtils {
    private static final Logger log = LoggerFactory.getLogger(CaffeineUtils.class);

    private CaffeineUtils() {
    }

    public static <K, V> Map<K, V> selectMapWithLocal(String biz, LoadingCache<K, V> cache, Set<K> cacheKeys, Function<Set<K>, Map<K, V>> loadFunc) {
        HashMap<@NonNull K, @NonNull V> allPresent = cache.getAllPresent(cacheKeys);
        if (MapUtils.isEmpty((Map)allPresent)) {
            allPresent = new HashMap();
        }
        return CaffeineUtils.putNoCache(biz, cache, cacheKeys, allPresent, loadFunc);
    }

    public static <K, V, K1, V1> Map<K1, V1> convertMap(Map<K, V> cacheMap, Function<K, K1> keyFunc, Function<V, V1> valFunc) {
        return cacheMap.entrySet().stream().filter(entry -> valFunc.apply(entry.getValue()) != null).collect(Collectors.toMap(entry -> keyFunc.apply(entry.getKey()), entry -> valFunc.apply(entry.getValue()), (v1, v2) -> v2));
    }

    private static <K, V> Map<@NonNull K, @NonNull V> putNoCache(String biz, LoadingCache<K, V> cache, Set<K> cacheKeys, Map<@NonNull K, @NonNull V> allPresent, Function<Set<K>, Map<K, V>> loadFunc) {
        Set noCacheKeys = cacheKeys.stream().filter(cacheKey -> !allPresent.containsKey(cacheKey)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(noCacheKeys)) {
            return allPresent;
        }
        Map<Object, Object> loadMap = loadFunc.apply(noCacheKeys);
        if (MapUtils.isEmpty(loadMap)) {
            log.warn("[{}], \u6279\u91cf\u67e5\u8be2\u672a\u67e5\u8be2\u5230, cacheKeys={}", (Object)biz, (Object)JSON.toJSONString(cacheKeys));
            return allPresent;
        }
        HashMap<@NonNull K, @NonNull V> resultMap = new HashMap(allPresent);
        if (loadMap.size() != noCacheKeys.size()) {
            log.warn("[{}], \u6279\u91cf\u67e5\u8be2\u90e8\u5206\u672a\u67e5\u8be2\u5230, cacheKeys={}, loadMap.size={}", new Object[]{biz, JSON.toJSONString(cacheKeys), loadMap.size()});
        }
        loadMap.forEach((key, value) -> {
            cache.put(key, value);
            resultMap.put(key, value);
        });
        return resultMap;
    }
}

