/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonPrizeDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonInterfaceConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitAbsoluteConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityExtEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeExtEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityPeriodicUnitEnum;
import cn.com.duiba.quanyi.center.api.utils.activity.ActivityCommonErrorCodeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class ActivityCommonUtils {
    private ActivityCommonUtils() {
    }

    public static void throwBiz(ActivityCommonErrorCodeEnum errorCodeEnum) throws BizException {
        throw new BizException(errorCodeEnum.getDesc()).withCode(errorCodeEnum.name());
    }

    public static ActivityCommonDetailDto convertDetail(ActivityDto activityDto, Map<Integer, String> activityExtMap, List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) throws BizException {
        if (activityDto == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000003);
        }
        if (MapUtils.isEmpty(activityExtMap)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000004);
        }
        if (CollectionUtils.isEmpty(prizeList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000005);
        }
        if (MapUtils.isEmpty(prizeExtMap)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000006);
        }
        ActivityCommonDetailDto detailDto = (ActivityCommonDetailDto)BeanUtils.copy((Object)activityDto, ActivityCommonDetailDto.class);
        detailDto.setDrawType(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.PRIZE_DRAW_TYPE.getType()));
        detailDto.setSkinId(activityExtMap.get(ActivityExtEnum.SKIN_ID.getType()));
        detailDto.setSubType(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_SUB_TYPE.getType()));
        detailDto.setUserLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_USER_LIMIT.getType(), ActivityCommonUserLimitConfDto.class));
        detailDto.setTimeLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_OPEN_TIME_LIMIT.getType(), ActivityCommonTimeLimitConfDto.class));
        detailDto.setTakeNumLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_TIMES_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setWhiteConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_WHITE_LIST.getType(), ActivityCommonWhiteConfDto.class));
        detailDto.setBlackConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_BLACK_LIST.getType(), ActivityCommonBlackConfDto.class));
        detailDto.setReachStandardConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_REACH_STANDARD.getType(), ActivityCommonReachStandardConfDto.class));
        detailDto.setPayConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_PAY_CONF.getType(), ActivityCommonPayConfDto.class));
        detailDto.setSignUpConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_SIGN_UP.getType(), ActivityCommonSignUpConfDto.class));
        detailDto.setEnableStore(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_STORE_CONF.getType()));
        detailDto.setNoticeConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_NOTICE_CONF.getType(), ActivityCommonNoticeConfDto.class));
        detailDto.setInterfaceConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_INTERFACE_CONF.getType(), ActivityCommonInterfaceConfDto.class));
        detailDto.setPrizeList(ActivityCommonUtils.buildPrizeDetail(prizeList, prizeExtMap));
        return detailDto;
    }

    private static List<ActivityCommonPrizeDetailDto> buildPrizeDetail(List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) {
        ArrayList<ActivityCommonPrizeDetailDto> list = new ArrayList<ActivityCommonPrizeDetailDto>();
        for (ActivityPrizeDto prizeDto : prizeList) {
            ActivityCommonPrizeDetailDto detailDto = ActivityCommonUtils.buildPrizeDetail(prizeDto, prizeExtMap.get(prizeDto.getId()));
            list.add(detailDto);
        }
        return list;
    }

    private static ActivityCommonPrizeDetailDto buildPrizeDetail(ActivityPrizeDto prizeDto, Map<Integer, String> extMap) {
        ActivityCommonPrizeDetailDto detailDto = (ActivityCommonPrizeDetailDto)BeanUtils.copy((Object)prizeDto, ActivityCommonPrizeDetailDto.class);
        detailDto.setTakeNumLimit(ActivityCommonUtils.getObjByExt(extMap, ActivityPrizeExtEnum.TAKE_NUM_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setStockLimit(ActivityCommonUtils.getObjByExt(extMap, ActivityPrizeExtEnum.STOCK_LIMIT.getType(), ActivityCommonPrizeStockLimitConfDto.class));
        return detailDto;
    }

    private static Integer getIntegerByExt(Map<Integer, String> extMap, Integer confName) throws BizException {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        if (!NumberUtils.isNumeric((String)val)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000008);
        }
        return Integer.parseInt(val);
    }

    private static <T> T getObjByExt(Map<Integer, String> extMap, Integer confName, Class<T> clazz) {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return (T)JSON.parseObject((String)val, clazz);
    }

    public static Triple<Boolean, Date, Date> calculateAccessTime(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now) throws BizException {
        ActivityPeriodicUnitEnum unitEnum = ActivityPeriodicUnitEnum.getByCode(timeLimitConf.getPeriodicUnit());
        if (unitEnum == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
        }
        switch (unitEnum) {
            case FOREVER: {
                return Triple.of((Object)true, null, null);
            }
            case ABSOLUTE: {
                return ActivityCommonUtils.calculateAccessTimeByAbsolute(timeLimitConf.getAbsoluteTimeList(), now);
            }
            case DAY: {
                return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, 1);
            }
            case WEEK: {
                return ActivityCommonUtils.calculateAccessTimeByWeek(timeLimitConf, now);
            }
            case MONTH: {
                return ActivityCommonUtils.calculateAccessTimeByMonth(timeLimitConf, now);
            }
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
        return Triple.of((Object)false, null, null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByAbsolute(List<ActivityCommonTimeLimitAbsoluteConfDto> absoluteTimeList, Date now) {
        if (CollectionUtils.isEmpty(absoluteTimeList)) {
            return Triple.of((Object)false, null, null);
        }
        List inTimeList = absoluteTimeList.stream().filter(time -> time.getAbsoluteStartTime().before(now) && time.getAbsoluteEndTime().after(now)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inTimeList)) {
            Date date = inTimeList.stream().map(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteEndTime).max(Comparator.naturalOrder()).orElse(null);
            return Triple.of((Object)true, null, (Object)date);
        }
        Date date = absoluteTimeList.stream().map(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteStartTime).filter(absoluteStartTime -> absoluteStartTime.after(now)).min(Comparator.naturalOrder()).orElse(null);
        return Triple.of((Object)false, (Object)date, null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByDay(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now, int nextDayOffset) {
        boolean inTime;
        Date dayStartTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0);
        Date dayEndTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59);
        boolean bl = inTime = dayStartTime.before(now) && dayEndTime.after(now);
        if (inTime) {
            return Triple.of((Object)true, null, (Object)dayEndTime);
        }
        if (now.before(dayStartTime)) {
            return Triple.of((Object)false, (Object)dayStartTime, null);
        }
        return Triple.of((Object)false, (Object)DateUtils.daysAddOrSub((Date)dayStartTime, (int)nextDayOffset), null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByWeek(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now) {
        if (CollectionUtils.isEmpty(timeLimitConf.getWeekLimitList())) {
            return Triple.of((Object)false, null, null);
        }
        int currentWeekDay = ActivityCommonUtils.getCurrentWeekDay(now);
        if (!timeLimitConf.getWeekLimitList().contains(currentWeekDay)) {
            Date dayStartTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0);
            return Triple.of((Object)false, (Object)DateUtils.daysAddOrSub((Date)dayStartTime, (int)ActivityCommonUtils.getNextWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList())), null);
        }
        if (ActivityCommonUtils.dayNotAllTime(timeLimitConf)) {
            return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, ActivityCommonUtils.getNextWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList()));
        }
        int lastWeekDayOffset = ActivityCommonUtils.getLastWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList());
        if (lastWeekDayOffset < 0) {
            return Triple.of((Object)true, null, null);
        }
        Date dayEndTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59);
        return Triple.of((Object)true, null, (Object)DateUtils.daysAddOrSub((Date)dayEndTime, (int)lastWeekDayOffset));
    }

    private static int getLastWeekDayOffset(int currentWeekDay, List<Integer> weekLimitList) {
        int index;
        int i;
        if (weekLimitList.size() >= 7) {
            return -1;
        }
        Collections.sort(weekLimitList);
        int lastWeekDay = currentWeekDay;
        for (i = index = weekLimitList.indexOf(currentWeekDay); i < weekLimitList.size(); ++i) {
            Integer weekDay = weekLimitList.get(i);
            if (weekDay - lastWeekDay > 1) {
                return lastWeekDay - currentWeekDay;
            }
            if (weekDay - lastWeekDay != 1) continue;
            lastWeekDay = weekDay;
        }
        for (i = 0; i < index; ++i) {
            int weekDay = weekLimitList.get(i) + 7;
            if (weekDay - lastWeekDay > 1) {
                return lastWeekDay - currentWeekDay;
            }
            if (weekDay - lastWeekDay != 1) continue;
            lastWeekDay = weekDay;
        }
        return lastWeekDay - currentWeekDay;
    }

    private static int getNextWeekDayOffset(int currentWeekDay, List<Integer> weekLimitList) {
        int nextWeek = ActivityCommonUtils.getNextWeekDay(currentWeekDay, weekLimitList);
        if (nextWeek >= currentWeekDay) {
            return nextWeek - currentWeekDay;
        }
        return nextWeek + 7 - currentWeekDay;
    }

    private static int getNextWeekDay(int currentWeekDay, List<Integer> weekLimitList) {
        Collections.sort(weekLimitList);
        for (Integer weekDay : weekLimitList) {
            if (weekDay <= currentWeekDay) continue;
            return weekDay;
        }
        return weekLimitList.get(0);
    }

    private static int getCurrentWeekDay(Date now) {
        int week = ActivityCommonUtils.getDateField(now, 7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByMonth(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now) {
        int currentMonthDay = ActivityCommonUtils.getDateField(now, 5);
        int currentMonth = ActivityCommonUtils.getDateField(now, 2);
        if (currentMonthDay < timeLimitConf.getMonthStartTimeByDay() || currentMonthDay > timeLimitConf.getMonthEndTimeByDay()) {
            int month = currentMonthDay < timeLimitConf.getMonthStartTimeByDay() ? currentMonth : currentMonth + 1;
            return Triple.of((Object)false, (Object)ActivityCommonUtils.getTime(now, month, timeLimitConf.getMonthStartTimeByDay(), timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0), null);
        }
        if (ActivityCommonUtils.dayNotAllTime(timeLimitConf)) {
            return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, ActivityCommonUtils.getNextMonthDayOffset(currentMonthDay, currentMonth, timeLimitConf, now));
        }
        return Triple.of((Object)true, null, (Object)ActivityCommonUtils.getTime(now, currentMonth, timeLimitConf.getMonthEndTimeByDay(), timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59));
    }

    private static int getNextMonthDayOffset(int currentMonthDay, int currentMonth, ActivityCommonTimeLimitConfDto timeLimitConf, Date now) {
        if (currentMonthDay < timeLimitConf.getMonthEndTimeByDay()) {
            return 1;
        }
        int currentDayOfYear = ActivityCommonUtils.getDateField(now, 6);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(2, currentMonth + 1);
        calendar.set(5, timeLimitConf.getMonthStartTimeByDay());
        return calendar.get(6) - currentDayOfYear;
    }

    private static int getDateField(Date now, int field) {
        Calendar calWeek = Calendar.getInstance();
        calWeek.setTime(now);
        return calWeek.get(field);
    }

    private static boolean dayNotAllTime(ActivityCommonTimeLimitConfDto timeLimitConf) {
        return timeLimitConf.getDayStartHour() != 0 || timeLimitConf.getDayStartMinute() != 0 || timeLimitConf.getDayEndHour() != 23 || timeLimitConf.getDayEndMinute() != 59;
    }

    public static Date getTime(Date date, Integer month, Integer dayOfMonth, Integer hour, Integer minute, Integer second) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (month != null) {
            calendar.set(2, month);
        }
        if (dayOfMonth != null) {
            calendar.set(5, dayOfMonth);
        }
        if (hour != null) {
            calendar.set(11, hour);
        }
        if (minute != null) {
            calendar.set(12, minute);
        }
        if (second != null) {
            calendar.set(13, second);
        }
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

