package cn.com.duiba.quanyi.center.api.dto.activity.common.ext;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/28 10:23
 */
@Data
public class ActivityCommonTimeLimitConfDto implements Serializable {
    
    private static final long serialVersionUID = 1048992100960769910L;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enable;

    /**
     * 周期单位
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityPeriodicUnitEnum
     */
    private Integer periodicUnit;

    /**
     * 日开始时间-小时（周期单位为：日、周、月、季度时有值）
     */
    private Integer dayStartHour;

    /**
     * 日开始时间-分钟（周期单位为：日、周、月、季度时有值）
     */
    private Integer dayStartMinute;

    /**
     * 日结束时间-小时（周期单位为：日、周、月、季度时有值）
     */
    private Integer dayEndHour;

    /**
     * 日结束时间-分钟（周期单位为：日、周、月、季度时有值）
     */
    private Integer dayEndMinute;

    /**
     * 周限制时间（周期单位为：周 时有值）
     * 1表示周一，7表示周日
     * 周限制和月限制互斥
     */
    private List<Integer> weekLimitList;

    /**
     * 月限制开始时间（周期单位为：月 时有值）
     */
    private Integer monthStartTimeByDay;

    /**
     * 月限制结束时间（周期单位为：月 时有值）
     */
    private Integer monthEndTimeByDay;

    /**
     * 绝对时间，时间区间
     */
    private List<ActivityCommonTimeLimitAbsoluteConfDto> absoluteTimeList;
}
