package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 09:52
 */
@Data
public class ActivityCommonUserResultDto implements Serializable {
    
    private static final long serialVersionUID = 3824015657716216990L;
    
    /**
     * 剩余领取次数
     */
    private Long surplusTakeNum;

    /**
     * 活动是否可领取详情
     */
    private ActivityCommonUserResultCanTakeDto activityCanTake;

    /**
     * 当前是否可以报名
     * 当前不在报名周期/活动无参与权限
     */
    private Boolean canSignedUp;

    /**
     * 本期是否已报名
     */
    private Boolean signedUp;

    /**
     * 报名ID(不需要校验时是本期已报名ID，需要验证时，是符合周期的报名ID)
     */
    private Long signUpId;

    /**
     * 处理中的订单号，为null或空字符串说明不存在处理中订单
     */
    private String processingBizOrderNo;

    /**
     * 展示的用户ID，活动开启展示用户ID时有值
     */
    private String showUserId;

    /**
     * 无法展示用户ID的原因
     */
    private String showUserIdErrCode;

    /**
     * 奖品列表
     */
    private List<ActivityCommonUserPrizeResultDto> prizeList;

}
