package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * API订单-活动扩展信息
 * @author mybatis generator 
 * @date 2024-07-03
 */
@Data
public class ApiOrderActivityDto implements Serializable {
     
    private static final long serialVersionUID = 17199738993104567L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 对接配置Id
     */
    private Long apiJointId;

    /**
     * 客户用户唯一标记
     */
    private String uid;

    /**
     * 权益用户ID
     */
    private Long userId;

    /**
     * 微信appId
     */
    private String wxAppId;

    /**
     * 用户微信openId，微信环境有值
     */
    private String wxOpenId;

    /**
     * 状态：1-未验证，2-无需验证，3-验证通过，4-验证不通过
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiOrderActivityValidateStatusEnum
     */
    private Integer validateStatus;

    /**
     * 验证响应结果
     */
    private String validateResult;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误原因
     */
    private String errMsg;

    /**
     * 开发者自有参数 兑吧透传
     */
    private String remark;
}