package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/3/28 16:25
 **/
@Getter
@AllArgsConstructor
public enum ContractTypeEnum {
    MAIN_CONTRACT(1, "权益主合同"),
    SUB_CONTRACT(2, "权益附属合同");

    private final Integer type;

    private final String desc;

    public static String getDesc(Integer type) {
        for (ContractTypeEnum contractTypeEnum : ContractTypeEnum.values()) {
            if (contractTypeEnum.getType().equals(type)) {
                return contractTypeEnum.getDesc();
            }
        }
        return null;
    }
}
