package cn.com.duiba.quanyi.center.api.param.settlement;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/12/2 11:25
 */
@Data
public class SettlementSaveParam implements Serializable {
    
    private static final long serialVersionUID = 8576989338866751848L;

    /**
     * 商品类型：1-非垫资，2-垫资
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementGoodsTypeEnum
     */
    private Integer goodsType;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID
     */
    private List<Long> contactsIdList;

    /**
     * 对接人ID，多个以英文逗号分隔
     */
    private String contactsIds;

    /**
     * 需求ID
     */
    private List<Long> demandIdList;

    /**
     * 结算需求ID，多个以英文逗号分隔
     */
    private String demandIds;

    /**
     * 实际结算对接人
     */
    private Long settlementContactsId;

    /**
     * 结算方式
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementTypeEnum
     */
    private Integer settlementType;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * 结算单名称
     */
    private String settlementName;

    /**
     * 方案key
     */
    private String programmeKey;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 应收金额，单位分
     */
    private Long receivableAmount;

    /**
     * 商品数量
     */
    private Long goodsNum;

    /**
     * 商品唯一标记数量
     */
    private Long uniqueMarkNum;

    /**
     * 汇总容差金额
     */
    private Long sumToleranceAmount;

}
