package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeCouponDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeCouponSearchParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CouponPageQueryParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 优惠券表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeCouponService {
     
    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 优惠券集合
     */
    List<CcbLifeCouponDto> selectList(CcbLifeCouponSearchParam param);


    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 优惠券集合
     */
    List<CcbLifeCouponDto> selectListNoPage(CcbLifeCouponSearchParam param);


    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 优惠券
     */
    CcbLifeCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 优惠券
     * @return 执行结果
     */
    int insert(CcbLifeCouponDto dto);

    /**
     * 批量插入数据到优惠券表中
     * @param dtos
     */
    int batchInsert(List<CcbLifeCouponDto> dtos);

    /**
     * 更新
     * @param dto 优惠券
     * @return 影响行数
     */
    int update(CcbLifeCouponDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据文件id查询导入的数量
     * @param fileIds
     * @return
     */
    Map<Long, Long> selectCountByFileIds(List<Long> fileIds);

    /**
     * 批量修改
     * @param dtos
     * @return
     */
    Integer batchUpdate(List<CcbLifeCouponDto> dtos);
}