package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyRefDto;

import java.util.List;

/**
 * 开票申请添加的结算单或预付款
 * @author kjj mybatis generator 
 * @date 2025-03-10
 */
@AdvancedFeignClient
public interface RemoteInvoiceApplyRefService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 开票申请添加的结算单或预付款
     */
    InvoiceApplyRefDto selectById(Long id);

    /**
     * 根据开票申请查询
     * @param invoiceApplyId 开票申请ID
     * @return 开票申请添加的结算单或预付款
     */
    List<InvoiceApplyRefDto> selectByInvoiceApplyId(Long invoiceApplyId);

    /**
     * 根据开票申请主键批量查询
     * @param invoiceApplyIds 开票申请主键
     * @return 开票申请添加的结算单或预付款
     */
    List<InvoiceApplyRefDto> selectByInvoiceApplyIds(List<Long> invoiceApplyIds);


    /**
     * 根据关联ID查询
     * @param settlementId 开票凭证ID
     * @return 开票申请添加的结算单或预付款
     */
    List<InvoiceApplyRefDto> selectBySettlementId(Long settlementId);
}