package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/7/25 16:17
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GeneralCouponAutoCreateExtInfoDto extends AlipayActivityAutoCreateExtInfoDto {
    private static final long serialVersionUID = -2654722748013662774L;

    /**
     * 基础信息
     */
    private GeneralCouponAutoCreateExtInfoDto.BaseInfo baseInfo;

    @Data
    public static class BaseInfo {
        /**
         * 活动名称
         */
        private String activityName;

        /**
         * 业务类型
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.BusinessTypeEnum}
         */
        private Integer businessType;

        /**
         * 银行信息
         */
        private List<Bank> bank;

        /**
         * 银行卡bin列表
         */
        private List<String> bankCardBin;

        /**
         * 是否展示卡组织信息，多银行活动有效
         */
        private Boolean showCardOrgInfo;

        /**
         * 发放时间范围 YYYY-MM-DD HH:SS:mm 格式，[开始时间, 结束时间]
         */
        private List<String> timeRange;

        /**
         * 可用时间
         */
        private EnableTime sendTime;

        /**
         * 红包可用时间
         */
        private RedEnableTime enableTime;

        /**
         * 优惠信息
         */
        private DiscountInfo discountInfo;

        /**
         * 参与次数限制(活动期间每个用户可参与)
         */
        private Integer receiveLimit;

        /**
         * 频率限制
         */
        private TimeLimit timeLimit;

        /**
         * 活动预算
         */
        private String budgetAmount;

        /**
         * 可用场景限制 1-不限制 2-限制
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.SceneLimitTypeEnum}
         */
        private Integer sceneLimitType;

        /**
         * 是否勾选剔除信用卡还款场景 type为1时生效
         */
        private Boolean excludeRepayScene;

        /**
         * 限制场景 type为2时生效
         */
        private String sceneLimit;

        /**
         * 发放限制
         */
        private SendLimit sendLimit;


        /**
         * 指定人群id
         */
        private String personId;

        /**
         * 预警信息
         */
        private Alarm alarm;

    }

    @Data
    public static class RedEnableTime {
        /**
         * 类型 1立即生效 2次日凌晨生效 3固定时间区间
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.RedEnableTimeTypeEnum}
         */
        private Integer type;

        /**
         * 有效期天数 最大366 类型为1、2时有效
         */
        private Integer invalidDays;

        /**
         * 固定时间区间 值示例：['08:00:00,09:00:00', '10:00:00,12:00:00'] 类型为3时有效
         */
        private List<String> invalidTimeRange;
    }

    @Data
    public static class SendLimit {

        /**
         * 发放方式 1-仅api 2-仅支付宝二维码及链接发放 3-支付宝二维码、链接及API发放
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.SendLimitTypeEnum}
         */
        private Integer sendType;

        /**
         * 发放限制 1-仅限活动主体的应用（APPID）进行发放 2-指定应用（APPID）进行发放 （发放方式为1或3下存在）
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.SendControlTypeEnum}
         */
        private Integer sendControlType;

        /**
         * 发放的指定应用（APPID）（发放方式为1并且发放限制为2时存在）例如：1234567890123456 英文逗号隔开
         */
        private String sendControlContent;

        /**
         * API权限范围【发放的指定应用（APPID）时必填】 多选
         * 1-数字分行红包发放接口（默认必选）
         * 2-数字分行红包活动流水查询接口 可选
         * 3-数字分行红包活动配置查询接口 可选
         * 4-查询活动账单信息（仅渠道红包活动账单）可选
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.ApiPermissionTypeEnum}
         */
        private List<String> apiPermission;

        /**
         *  是否需要叠加公域流量 0-false 1-true （发放方式为1时默认false不可选，2、3时可选）
         */
        private Integer isOverlay;

        /**
         * 是否参加公域会场专项招商 0-false 1-true （发放方式为1、3时默认false不可选，2时可选）
         */
        private Integer isSpecial;

        /**
         * 会场类型 1单会场 2多会场（参加公域会场专项招商必选）
         */
        private Integer specialType;

        /**
         * 可选会场 1银行大促 2商户小程序（多会场下必选，多选，至少一个）
         */
        private List<Integer> multipleSpecialScene;
    }

    @Data
    public static class DiscountInfo {
        /**
         * 优惠类型 1-定额满减 2-随机满减
         * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.DiscountTypeEnum}
         */
        private Integer type;

        /**
         * 消费门槛金额
         */
        private String threshold;

        /**
         * 优惠金额，类型为1时需设置，threshold如果未填=默认优惠金额+0.01
         */
        private String discountAmount;

        /**
         * 优惠立减区间 类型为2时需设置 例如：[1.88, 6.88]
         */
        private List<String> discountReduceRange;
    }
}
