package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史开票
 * @author mybatis generator 
 * @date 2025-01-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceHistorySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17364024891153223L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 归属项目ID
     */
    private Long projectId;

    /**
     * 发票号
     */
    private String invoiceNum;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 发票时间
     */
    private Date invoiceIssueTime;

    /**
     * 已开票金额（单位分）
     */
    private Long invoicedAmount;

    /**
     * 已回款金额（单位分）
     */
    private Long receivedAmount;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 对接人id
     */
    private Long contactsId;

    /**
     * 客户id
     */
    private Long partnerId;

    /**
     * 发票抬头(精准匹配)
     */
    private String termInvoiceTitle;

    /**
     * 是否过滤0可关联金额
     */
    private boolean filterZeroAmount;
}