package cn.com.duiba.quanyi.center.api.param.qy.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.ClientNumberTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 白名单数量查询-参数
 * @Author cuizhoujian
 * @Date 2025-02-25 16:05:24
 */
@Data
public class ActivityTemplateWhiteCntParam implements Serializable {
    private static final long serialVersionUID = 5009808675396135713L;
    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 客户号
     */
    private String clientNumber;

    /**
     * 客户号类型
     * {@link ClientNumberTypeEnum}
     */
    private Integer clientNumberType;

    /**
     * 开始时间
     */
    private Date beginDate;
    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 用户状态 0 发奖用户 1 基础白名单用户
     */
    private Integer  userStatus;
}
