package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceHistoryDto;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceHistorySumAmountDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceHistorySearchParam;
import java.util.List;
import java.util.Set;

/**
 * 历史开票
 * @author kjj mybatis generator 
 * @date 2025-01-09
 */
@AdvancedFeignClient
public interface RemoteInvoiceHistoryService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 历史开票集合
     */
    List<InvoiceHistoryDto> selectPage(InvoiceHistorySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceHistorySearchParam param);

    /**
     * 批量新增
     * @param list
     * @return
     */
    int batchInsert(List<InvoiceHistoryDto> list);

    /**
     * 批量新增或更新
     * @param list
     * @return
     */
    int batchSaveOrUpdate(List<InvoiceHistoryDto> list);
    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
    /**
     * 根据开票号查询
     * @return 执行结果
     */
    List<InvoiceHistoryDto> selectByInvoiceNums(Set<String> invoiceNums);

    /**
     * 根据条件统计开票金额与回款金额结果
     * @param param 查询条件
     * @return 执行结果
     */
    InvoiceHistorySumAmountDto sumHistoryInvoiceAmount(InvoiceHistorySearchParam param);

    /**
     * 根据ids 查询历史发票
     * @param ids 历史发票id集合
     * @return 历史发票集合
     */
    List<InvoiceHistoryDto> selectByIds(List<Long> ids);

    /**
     * 根据id查询历史发票
     * @param id 历史发票id
     * @return 历史发票详情
     */
    InvoiceHistoryDto selectById(Long id);
}