package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动奖品排序类型枚举
 *
 * @author yangyukang
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeSortTypeEnum {

    /**
     * 上移
     */
    MOVE_UP(1, "上移"),

    /**
     * 下移
     */
    MOVE_DOWN(2, "下移"),

    /**
     * 置顶
     */
    MOVE_TOP(3, "置顶"),

    /**
     * 置底
     */
    MOVE_BOTTOM(4, "置底");

    /**
     * 编码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 通过code获取枚举
     *
     * @param code 编码
     * @return 枚举
     */
    public static ActivityPrizeSortTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }

        for (ActivityPrizeSortTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }

        return null;
    }
}