package cn.com.duiba.quanyi.center.api.enums.ccb;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author nongfu
 * @Date 2024/4/16 14:58
 */
@Getter
@AllArgsConstructor
public enum ChannelEnum {

    WX("wx", "微信"),
    ALI("ali", "支付宝");

    private final String channelType;

    private final String desc;


    private static final Map<String, ChannelEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ChannelEnum::getChannelType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param channelType 枚举值
     * @return 枚举
     */
    public static ChannelEnum getByType(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }
}
