package cn.com.duiba.quanyi.center.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 上传任务查询参数
 * @author lizhi
 * @date 2023/3/29 2:19 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class UploadTaskSearchParam extends PageQuery {

    private static final long serialVersionUID = 3056598906229207826L;
    
    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型 1-上传活动白名单
     * {@link cn.com.duiba.quanyi.center.api.enums.UploadBizTypeEnum}
     */
    private List<Integer> bizTypeList;

    /**
     * 上传人id
     */
    private Long operatorId;

    /**
     * 上传开始时间
     */
    private Date uploadStartTime;

    /**
     * 上传结束时间
     */
    private Date uploadEndTime;

}
