package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class DouYinCouponPageParam extends PageQuery {

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 抖音活动ID
     */
    private String douyinActId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private List<Long> demandGoodsIds;

    /**
     * 活动名称
     */
    private String douyinActName;

    /**
     * 需求id
     */

    private Long demandId;
    /**
     * skuId
     */
    private Long skuId;
    /**
     * 是否启用，0-不启用，1启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStatus;

    /**
     * 面额类型：1-固定，2-不固定
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 面额（固定面额时必填）
     */
    private Long amount;

    /**
     * 状态
     */
    private String status;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 项目ID
     */
    private Long projectId;

}
