package cn.com.duiba.quanyi.center.api.param.unionpay;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 银联卡卷库存表
 * @author mybatis generator 
 * @date 2025-04-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UnionPayActivityStockSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1745375336996753L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 银联卡卷主键, tb_union_pay_activity.id
     */
    private Long unionPayActivityId;

    /**
     * 总库存，根据总预算计算而来
     */
    private Long totalNum;

    /**
     * 已使用数量，业务中使用统计计数
     */
    private Long usedNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}