package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import java.util.List;
import java.util.Set;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityTagConfigDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityTagConfigPageQueryParam;

/**
 * 活动定制标签配置表
 *
 * @author mybatis generator
 * @date 2024-07-13
 */
@AdvancedFeignClient
public interface RemoteActivityTagConfigService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动标签配置
     */
    ActivityTagConfigDto selectById(Long id);

    /**
     * 根据标签名称查询
     *
     * @param activityTagName 标签名称
     * @return 活动标签配置
     */
    ActivityTagConfigDto selectByTagName(String activityTagName);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 活动标签配置列表
     */
    List<ActivityTagConfigDto> selectByIds(Set<Long> ids);

    /**
     * 创建活动标签配置
     *
     * @param activityTagConfigDto
     * @return id
     */
    Long insert(ActivityTagConfigDto activityTagConfigDto);

    /**
     * 更新活动标签配置
     *
     * @param activityTagConfigDto
     * @return 影响行数
     */
    int update(ActivityTagConfigDto activityTagConfigDto);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 活动标签配置列表
     */
    List<ActivityTagConfigDto> selectPage(ActivityTagConfigPageQueryParam param);

    /**
     * count
     *
     * @param param 查询参数
     * @return 数量
     */
    Integer count(ActivityTagConfigPageQueryParam param);
}