package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.UserTakeStatCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.take.UserTakeStatDto;
import cn.com.duiba.quanyi.center.api.param.activity.take.UserTakeStatSearchParam;
import java.util.List;

/**
 * 用户领取记录统计
 * @author kjj mybatis generator
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteUserTakeStatService {

    /**
     * 根据用户及活动查询
     * @param userId 用户ID
     * @param activityId 活动ID
     * @return 用户领取记录统计
     */
    List<UserTakeStatCacheDto> selectByUserActCache(Long userId, Long activityId);
}
