package cn.com.duiba.quanyi.center.api.remoteservice.unionpay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.unionpay.UnionPayActivityDto;
import cn.com.duiba.quanyi.center.api.param.coupon.UnionPayBindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.UnionPayCouponSaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.unionpay.UnionPayActivitySearchParam;
import java.util.List;

/**
 * 银联卡卷表
 * @author kjj mybatis generator 
 * @date 2025-04-23
 */
@AdvancedFeignClient
public interface RemoteUnionPayActivityService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 银联卡卷集合
     */
    List<UnionPayActivityDto> selectPage(UnionPayActivitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UnionPayActivitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联卡卷
     */
    UnionPayActivityDto selectById(Long id);

    /**
     * 通过主键ID批量查询
     * @param ids
     * @return
     */
    List<UnionPayActivityDto>  selectByIds(List<Long> ids);
    /**
     * 通过银联卷码ID 查询
     * @param discountId 银联卷码ID
     * @return 银联卡卷
     */
    UnionPayActivityDto selectByDiscountId(String discountId);

    /**
     * 新增
     * @param dto 银联卡卷
     * @return 执行结果
     */
    Long insert(UnionPayActivityDto dto);

    /**
     * 更新
     * @param dto 银联卡卷
     * @return 影响行数
     */
    int update(UnionPayActivityDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 保存或者更新银联卡卷
     * @param saveOrUpdateParam 入参数
     * @return 主键ID
     */
    Long saveOrUpdate(UnionPayCouponSaveOrUpdateParam saveOrUpdateParam);


    /**
     * 根据需求商品id查询绑定的批次号
     * @param demandGoodsId 需求商品ID
     * @return 银联支付劵列表
     */
    List<UnionPayActivityDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 通过需求商品ID 批量查询
     * @param demandGoodsIds 需求商品ID集合
     * @return
     */
    List<UnionPayActivityDto> findByDemandGoodsIds(List<Long> demandGoodsIds);

    /**
     * 批量绑定需求商品
     * @param unionPayBindDemandGoodsParam
     */
    int batchBindDemandGoods(List<UnionPayBindDemandGoodsParam> unionPayBindDemandGoodsParam);

    /**
     * 绑定需求商品
     * @param param
     */
    int bindDemandGoods(UnionPayBindDemandGoodsParam param);

    /**
     * 批量解绑需求商品ID
     * @param unbindCouponList 银联卡卷ID集合
     * @param demandGoodsId 需求商品
     */
    int batchUnbindDemandGoods(List<Long> unbindCouponList, Long demandGoodsId);



    /**
     * 根据需求ID查询
     * @param demandId 需求ID
     * @param skuId    商品skuId
     * @return 银联支付劵 列表
     */
    List<UnionPayActivityDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandGoodsId 需求商品ID
     * @param skuId 商品skuId
     * @return 银联支付劵 列表
     */
    List<UnionPayActivityDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);
}