package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSubTypeEnum;
import lombok.Data;

/**
 * 活动定制标签配置DTO
 *
 * @author yangyukang
 * @date 2024-07-13
 */
@Data
public class ActivityTagConfigDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动标签名称
     */
    private String activityTagName;

    /**
     * 活动标签类型
     * @see ActivityCommonSubTypeEnum
     */
    private String activityTagType;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 活动标签配置JSON
     *
        * @see ActivityTagJsonConfigDto
     */
    private String activityTagConfig;
}
