package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;

import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import lombok.Data;

/**
 * 活动定制标签JSON配置DTO
 *
 * @author yangyukang
 * @date 2024-07-16
 */
@Data
public class ActivityTagJsonConfigDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 白名单配置
     */
    private ActivityCommonWhiteConfDto whitelistConfig;

    /**
     * 黑名单配置
     */
    private ActivityCommonBlackConfDto blacklistConfig;

    /**
     * 达标配置
     */
    private ActivityCommonReachStandardConfDto attainmentConfig;

    /**
     * 支付信息
     */
    private ActivityCommonPayConfDto paymentInfo;

    /**
     * 报名信息
     */
    private ActivityCommonSignUpConfDto registrationInfo;

    /**
     * 门店配置是否开启 0-关闭 1-开启
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer storeConfigStatus;

    /**
     * 公告配置
     */
    private ActivityCommonNoticeConfDto noticeConfig;
}