package cn.com.duiba.quanyi.center.api.dto.activity.common.ext;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/5/7 16:16
 */
@Data
public class ActivityCommonInterfaceConfDto implements Serializable {
    
    private static final long serialVersionUID = -6425490812278813531L;

    /**
     * 是否隐藏无领奖资格奖品
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer hideWithoutPermission;

    /**
     * 是否开启一键领取
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableBatchTake;

    /**
     * 是否展示用户Id
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer showUserId;

    /**
     * 用户ID类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonUserIdTypeEnum
     */
    private Integer userIdType;

    /**
     * 是否展示库存
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer showStock;

    /**
     * 库存类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonShowStockTypeEnum
     */
    private Integer stockType;

    /**
     * 是否展示剩余抽奖次数
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer showSurplusTakeNum;

    /**
     * 界面配置json（详细的各个图片）
     */
    private String interfaceJson;
}
