package cn.com.duiba.quanyi.center.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.CommonBizRelationDto;
import cn.com.duiba.quanyi.center.api.param.common.CommonBizRelationSearchParam;
import java.util.List;

/**
 * 通用业务关联表
 * @author kjj mybatis generator 
 * @date 2025-03-05
 */
@AdvancedFeignClient
public interface RemoteCommonBizRelationService {

    /**
     * 根据业务id和bizType查询
     *
     * @param bizId   业务id
     * @param bizType 业务类型
     * @return 通用业务关联
     */
    List<CommonBizRelationDto> selectByBiz(Long bizId, Integer bizType);

    /**
     * 根据关联id和bizType查询
     *
     * @param bizRelationId 关联id
     * @param bizType         业务类型
     * @return 通用业务关联
     */
    List<CommonBizRelationDto> selectByRelation(Long bizRelationId, Integer bizType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 通用业务关联
     */
    CommonBizRelationDto selectById(Long id);

    /**
     * 新增
     * @param dto 通用业务关联
     * @return 执行结果
     */
    int insert(CommonBizRelationDto dto);

    /**
     * 更新
     * @param dto 通用业务关联
     * @return 影响行数
     */
    int update(CommonBizRelationDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}