package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentInvoiceRefDto;

import java.util.List;

/**
 * 回款与发票关联关系
 * @author kjj mybatis generator 
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentInvoiceRefService {

    /**
     * 根据发票批量查询
     * @param invoiceIds 发票ID
     * @return 回款与发票关联关系
     */
    List<ReceivedPaymentInvoiceRefDto> selectByInvoiceIds(List<Long> invoiceIds);

    /**
     * 根据发票批量查询
     * @param invoiceIds 发票ID
     * @param invoiceType 关联的发票类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.ReceivedInvoiceTypeEnum
     * @return 回款与发票关联关系
     */
    List<ReceivedPaymentInvoiceRefDto> selectByInvoiceIdsAndType(List<Long> invoiceIds,Integer invoiceType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款与发票关联关系
     */
    ReceivedPaymentInvoiceRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 回款与发票关联关系
     * @return 执行结果
     */
    int insert(ReceivedPaymentInvoiceRefDto dto);

    /**
     * 更新
     * @param dto 回款与发票关联关系
     * @return 影响行数
     */
    int update(ReceivedPaymentInvoiceRefDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据回款查询发票-回款关联关系集合
     * @param receivedId 回款id
     * @return 回款关联关系集合
     */
    List<ReceivedPaymentInvoiceRefDto> selectByReceivedId(Long receivedId);
}