package cn.com.duiba.quanyi.center.api.remoteservice.templatesconfig;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.templatesconfig.TemplatesConfigDetailValueDto;
import cn.com.duiba.quanyi.center.api.param.templatesconfig.TemplatesConfigDetailValueSearchParam;
import java.util.List;

/**
 * 模版配置详情-value表
 * @author kjj mybatis generator 
 * @date 2024-12-02
 */
@AdvancedFeignClient
public interface RemoteTemplatesConfigDetailValueService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 模版配置详情-value集合
     */
    List<TemplatesConfigDetailValueDto> selectPage(TemplatesConfigDetailValueSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TemplatesConfigDetailValueSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 模版配置详情-value
     */
    TemplatesConfigDetailValueDto selectById(Long id);

    /**
     * 新增
     * @param dto 模版配置详情-value
     * @return 执行结果
     */
    int insert(TemplatesConfigDetailValueDto dto);

    /**
     * 更新
     * @param dto 模版配置详情-value
     * @return 影响行数
     */
    int update(TemplatesConfigDetailValueDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}