package cn.com.duiba.quanyi.center.api.remoteservice.code;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.code.CodeUserRefDto;

import java.util.List;

/**
 * 用户渠道券码关联表
 *
 * @author lizhi
 * @date 2023/9/19 20:46
 */
@AdvancedFeignClient
public interface RemoteCodeUserRefService {

    /**
     * 根据用户和业务查询
     *
     * @param userId      用户ID
     * @param codeBizType 业务类型
     * @param codeBizId   业务ID
     * @return 用户渠道券码
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeBizTypeEnum
     */
    @Deprecated
    String selectCodeByUserBiz(Long userId, Integer codeBizType, Long codeBizId);

    /**
     * 根据用户和业务查询，用户是否已绑定过券码了
     *
     * @param userId      用户ID
     * @param codeBizType 业务类型
     * @param codeBizId   业务ID
     * @return 是否绑定过券码
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeBizTypeEnum
     */
    boolean hasBind(Long userId, Integer codeBizType, Long codeBizId);

    /**
     * 指定场景下，根据券码批量查询
     *
     * @param codeBizType
     * @param codeBizId
     * @param codeList
     * @return
     */
    List<CodeUserRefDto> selectByBizAndCodeList(Integer codeBizType, Long codeBizId, List<String> codeList);

    /**
     * 根据渠道和券码查询
     *
     * @param codeBizType
     * @param codeBizId
     * @param couponCode
     * @return
     */
    CodeUserRefDto selectByBizAndCode(Integer codeBizType, Long codeBizId, String couponCode);

    /**
     * 根据用户id和code查询
     *
     * @param userId
     * @param couponCode
     * @return
     */
    CodeUserRefDto selectByUserCode(Long userId, String couponCode);

    /**
     * 根据用户id和业务类型和业务id集合批量查询
     *
     * @param userId 用户id
     * @param codeBizType 业务类型
     * @param codeBizIds 业务id
     * @return 用户渠道券码关联
     */
    List<CodeUserRefDto> selectByUserAndBizTypeAndBizIdList(Long userId, Integer codeBizType, List<Long> codeBizIds);

    /**
     * 根据券码查询
     *
     * @param couponCode 券码
     * @return 用户渠道券码关联
     */
    List<CodeUserRefDto> selectByCode(String couponCode);

    /**
     * 更换绑定用户
     *
     * @param id id
     * @param newUserId 绑定的用户id
     * @return 结果
     */
    boolean changeBindUserId(Long id, Long newUserId);
}
