package cn.com.duiba.quanyi.center.api.remoteservice.demandorder;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demandorder.DemandOrderExportTaskDto;
import cn.com.duiba.quanyi.center.api.param.demandorder.DemandOrderExportTaskSearchParam;
import java.util.List;

/**
 * 需求单导出任务表
 * @author kjj mybatis generator 
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteDemandOrderExportTaskService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 需求单导出任务集合
     */
    List<DemandOrderExportTaskDto> selectPage(DemandOrderExportTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandOrderExportTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求单导出任务
     */
    DemandOrderExportTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 需求单导出任务
     * @return 执行结果
     */
    int insert(DemandOrderExportTaskDto dto);

    /**
     * 更新
     * @param dto 需求单导出任务
     * @return 影响行数
     */
    int update(DemandOrderExportTaskDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}