package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtCommonDto;

import java.util.Map;

/**
 * 用户通用扩展信息表
 * @author kjj mybatis generator 
 * @date 2025-04-15
 */
@AdvancedFeignClient
public interface RemoteUserExtCommonService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户通用扩展信息
     */
    UserExtCommonDto selectById(Long id);

    /**
     * 根据userId查询（redis缓存）
     * @param userId 用户ID
     * @return key:枚举，value：对应的值
     */
    Map<Integer, String> selectByUserCache(Long userId);

    /**
     * 新增
     * @param dto 用户通用扩展信息
     * @return 执行结果
     */
    int insert(UserExtCommonDto dto);

    /**
     * 更新
     * @param dto 用户通用扩展信息
     * @return 影响行数
     */
    int update(UserExtCommonDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}