/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeStockDto;
import cn.com.duiba.quanyi.center.api.dto.activity.PrizePeriodStockDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityBlackWhiteListCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonCacheTypeEnum;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonCustomSignUpVerifyDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonReachStandardDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonUserApiVerifyDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonUserCustomVerifyDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityCommonUserInfoCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityPrizeReceiveRecordCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivitySignUpCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.PayOrderTakeVoucherCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.UserTakeStatCacheDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonPrizeDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonInterfaceConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardApiConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardWhiteListConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitAbsoluteConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonUserPrizeResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonUserResultCanTakeDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonUserResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.result.ActivityCommonUserResultSubPrizeDto;
import cn.com.duiba.quanyi.center.api.dto.common.ActivityPeriodicDto;
import cn.com.duiba.quanyi.center.api.dto.pay.PayOrderDto;
import cn.com.duiba.quanyi.center.api.dto.user.UserDto;
import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityExtEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeDrawTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeExtEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityBlackWhiteListTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonBlackWhiteUserMarkTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonDimensionEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonReachStandardTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSignUpVerifyRuleTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonUserIdTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonUserVerifyStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityPeriodicUnitEnum;
import cn.com.duiba.quanyi.center.api.enums.user.UserExtCommonKeyEnum;
import cn.com.duiba.quanyi.center.api.utils.BizConsumer;
import cn.com.duiba.quanyi.center.api.utils.activity.ActivityCommonErrorCodeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ActivityCommonUtils {
    private ActivityCommonUtils() {
    }

    public static void throwBiz(ActivityCommonErrorCodeEnum errorCodeEnum) throws BizException {
        throw new BizException(errorCodeEnum.getDesc()).withCode(errorCodeEnum.name());
    }

    private static void throwBiz(String code) throws BizException {
        ActivityCommonErrorCodeEnum errorCodeEnum = ActivityCommonErrorCodeEnum.getByName(code);
        if (errorCodeEnum == null) {
            throw new BizException("\u672a\u77e5\u9519\u8bef\u7801").withCode(code);
        }
        ActivityCommonUtils.throwBiz(errorCodeEnum);
    }

    public static ActivityCommonDetailDto convertDetail(ActivityDto activityDto, Map<Integer, String> activityExtMap, List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) throws BizException {
        if (activityDto == null || !LogicDeleteEnum.NON_DELETED.getCode().equals(activityDto.getLogicDelete())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000001);
            return null;
        }
        if (!BizActTypeEnum.COMMON.getType().equals(activityDto.getActivityType())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000017);
            return null;
        }
        if (MapUtils.isEmpty(activityExtMap)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000004);
            return null;
        }
        if (CollectionUtils.isEmpty(prizeList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000005);
            return null;
        }
        if (MapUtils.isEmpty(prizeExtMap)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000006);
            return null;
        }
        ActivityCommonDetailDto detailDto = (ActivityCommonDetailDto)BeanUtils.copy((Object)activityDto, ActivityCommonDetailDto.class);
        detailDto.setDrawType(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.PRIZE_DRAW_TYPE.getType()));
        detailDto.setSkinId(activityExtMap.get(ActivityExtEnum.SKIN_ID.getType()));
        detailDto.setSubType(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_SUB_TYPE.getType()));
        detailDto.setUserLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_USER_LIMIT.getType(), ActivityCommonUserLimitConfDto.class));
        detailDto.setTimeLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_OPEN_TIME_LIMIT.getType(), ActivityCommonTimeLimitConfDto.class));
        detailDto.setTakeNumLimit(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_TAKE_TIMES_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setWhiteConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_WHITE_LIST.getType(), ActivityCommonWhiteConfDto.class));
        detailDto.setBlackConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_BLACK_LIST.getType(), ActivityCommonBlackConfDto.class));
        detailDto.setReachStandardConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_REACH_STANDARD.getType(), ActivityCommonReachStandardConfDto.class));
        detailDto.setPayConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_PAY_CONF.getType(), ActivityCommonPayConfDto.class));
        detailDto.setSignUpConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_SIGN_UP.getType(), ActivityCommonSignUpConfDto.class));
        detailDto.setEnableStore(ActivityCommonUtils.getIntegerByExt(activityExtMap, ActivityExtEnum.COMMON_STORE_CONF.getType()));
        detailDto.setNoticeConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_NOTICE_CONF.getType(), ActivityCommonNoticeConfDto.class));
        detailDto.setInterfaceConf(ActivityCommonUtils.getObjByExt(activityExtMap, ActivityExtEnum.COMMON_INTERFACE_CONF.getType(), ActivityCommonInterfaceConfDto.class));
        detailDto.setPrizeList(ActivityCommonUtils.buildPrizeDetail(prizeList, prizeExtMap));
        return detailDto;
    }

    private static List<ActivityCommonPrizeDetailDto> buildPrizeDetail(List<ActivityPrizeDto> prizeList, Map<Long, Map<Integer, String>> prizeExtMap) {
        ArrayList<ActivityCommonPrizeDetailDto> list = new ArrayList<ActivityCommonPrizeDetailDto>();
        for (ActivityPrizeDto prizeDto : prizeList) {
            ActivityCommonPrizeDetailDto detailDto = ActivityCommonUtils.buildPrizeDetail(prizeDto, prizeExtMap.get(prizeDto.getId()));
            list.add(detailDto);
        }
        return list;
    }

    private static ActivityCommonPrizeDetailDto buildPrizeDetail(ActivityPrizeDto prizeDto, Map<Integer, String> extMap) {
        ActivityCommonPrizeDetailDto detailDto = (ActivityCommonPrizeDetailDto)BeanUtils.copy((Object)prizeDto, ActivityCommonPrizeDetailDto.class);
        detailDto.setProbabilityValue(extMap.get(ActivityPrizeExtEnum.PROBABILITY_VALUE.getType()));
        detailDto.setTakeNumLimit(ActivityCommonUtils.getObjByExt(extMap, ActivityPrizeExtEnum.TAKE_NUM_LIMIT.getType(), ActivityCommonTakeLimitConfDto.class));
        detailDto.setStockLimit(ActivityCommonUtils.getObjByExt(extMap, ActivityPrizeExtEnum.STOCK_LIMIT.getType(), ActivityCommonPrizeStockLimitConfDto.class));
        return detailDto;
    }

    private static Integer getIntegerByExt(Map<Integer, String> extMap, Integer confName) throws BizException {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        if (!NumberUtils.isNumeric((String)val)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000008);
        }
        return Integer.parseInt(val);
    }

    private static <T> T getObjByExt(Map<Integer, String> extMap, Integer confName, Class<T> clazz) {
        if (MapUtils.isEmpty(extMap)) {
            return null;
        }
        String val = extMap.get(confName);
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return (T)JSON.parseObject((String)val, clazz);
    }

    public static Triple<Boolean, Date, Date> calculateAccessTime(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now, boolean needTime) throws BizException {
        ActivityPeriodicUnitEnum unitEnum = ActivityPeriodicUnitEnum.getByCode(timeLimitConf.getPeriodicUnit());
        if (unitEnum == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
        }
        switch (unitEnum) {
            case FOREVER: {
                return Triple.of((Object)true, null, null);
            }
            case ABSOLUTE: {
                return ActivityCommonUtils.calculateAccessTimeByAbsolute(timeLimitConf.getAbsoluteTimeList(), now, needTime);
            }
            case DAY: {
                return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, needTime, 1);
            }
            case WEEK: {
                return ActivityCommonUtils.calculateAccessTimeByWeek(timeLimitConf, now, needTime);
            }
            case MONTH: {
                return ActivityCommonUtils.calculateAccessTimeByMonth(timeLimitConf, now, needTime);
            }
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
        return Triple.of((Object)false, null, null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByAbsolute(List<ActivityCommonTimeLimitAbsoluteConfDto> absoluteTimeList, Date now, boolean needTime) {
        if (CollectionUtils.isEmpty(absoluteTimeList)) {
            return Triple.of((Object)false, null, null);
        }
        List inTimeList = absoluteTimeList.stream().filter(time -> time.getAbsoluteStartTime().before(now) && time.getAbsoluteEndTime().after(now)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inTimeList)) {
            Date date = needTime ? (Date)inTimeList.stream().map(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteEndTime).max(Comparator.naturalOrder()).orElse(null) : null;
            return Triple.of((Object)true, null, date);
        }
        Date date = needTime ? (Date)absoluteTimeList.stream().map(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteStartTime).filter(absoluteStartTime -> absoluteStartTime.after(now)).min(Comparator.naturalOrder()).orElse(null) : null;
        return Triple.of((Object)false, date, null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByDay(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now, boolean needTime, int nextDayOffset) {
        boolean inTime;
        Date dayStartTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0);
        Date dayEndTime = ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59);
        boolean bl = inTime = dayStartTime.before(now) && dayEndTime.after(now);
        if (inTime) {
            return Triple.of((Object)true, null, (Object)(needTime ? dayEndTime : null));
        }
        if (now.before(dayStartTime)) {
            return Triple.of((Object)false, (Object)(needTime ? dayStartTime : null), null);
        }
        return Triple.of((Object)false, (Object)(needTime ? DateUtils.daysAddOrSub((Date)dayStartTime, (int)nextDayOffset) : null), null);
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByWeek(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now, boolean needTime) {
        if (CollectionUtils.isEmpty(timeLimitConf.getWeekLimitList())) {
            return Triple.of((Object)false, null, null);
        }
        int currentWeekDay = ActivityCommonUtils.getCurrentWeekDay(now);
        if (!timeLimitConf.getWeekLimitList().contains(currentWeekDay)) {
            Date dayStartTime = needTime ? ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0) : null;
            return Triple.of((Object)false, needTime ? DateUtils.daysAddOrSub((Date)dayStartTime, (int)ActivityCommonUtils.getNextWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList())) : null, null);
        }
        if (ActivityCommonUtils.dayNotAllTime(timeLimitConf)) {
            return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, needTime, needTime ? ActivityCommonUtils.getNextWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList()) : 0);
        }
        if (timeLimitConf.getWeekLimitList().size() >= 7) {
            return Triple.of((Object)true, null, null);
        }
        Date dayEndTime = needTime ? ActivityCommonUtils.getTime(now, null, null, timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59) : null;
        return Triple.of((Object)true, null, needTime ? DateUtils.daysAddOrSub((Date)dayEndTime, (int)ActivityCommonUtils.getLastWeekDayOffset(currentWeekDay, timeLimitConf.getWeekLimitList())) : null);
    }

    private static int getLastWeekDayOffset(int currentWeekDay, List<Integer> weekLimitList) {
        int index;
        int i;
        Collections.sort(weekLimitList);
        int lastWeekDay = currentWeekDay;
        for (i = index = weekLimitList.indexOf(currentWeekDay); i < weekLimitList.size(); ++i) {
            Integer weekDay = weekLimitList.get(i);
            if (weekDay - lastWeekDay > 1) {
                return lastWeekDay - currentWeekDay;
            }
            if (weekDay - lastWeekDay != 1) continue;
            lastWeekDay = weekDay;
        }
        for (i = 0; i < index; ++i) {
            int weekDay = weekLimitList.get(i) + 7;
            if (weekDay - lastWeekDay > 1) {
                return lastWeekDay - currentWeekDay;
            }
            if (weekDay - lastWeekDay != 1) continue;
            lastWeekDay = weekDay;
        }
        return lastWeekDay - currentWeekDay;
    }

    private static int getNextWeekDayOffset(int currentWeekDay, List<Integer> weekLimitList) {
        int nextWeek = ActivityCommonUtils.getNextWeekDay(currentWeekDay, weekLimitList);
        if (nextWeek >= currentWeekDay) {
            return nextWeek - currentWeekDay;
        }
        return nextWeek + 7 - currentWeekDay;
    }

    private static int getNextWeekDay(int currentWeekDay, List<Integer> weekLimitList) {
        Collections.sort(weekLimitList);
        for (Integer weekDay : weekLimitList) {
            if (weekDay <= currentWeekDay) continue;
            return weekDay;
        }
        return weekLimitList.get(0);
    }

    private static int getCurrentWeekDay(Date now) {
        int week = ActivityCommonUtils.getDateField(now, 7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    private static Triple<Boolean, Date, Date> calculateAccessTimeByMonth(ActivityCommonTimeLimitConfDto timeLimitConf, @Nonnull Date now, boolean needTime) {
        int currentMonthDay = ActivityCommonUtils.getDateField(now, 5);
        int currentMonth = ActivityCommonUtils.getDateField(now, 2);
        if (currentMonthDay < timeLimitConf.getMonthStartTimeByDay() || currentMonthDay > timeLimitConf.getMonthEndTimeByDay()) {
            int month = currentMonthDay < timeLimitConf.getMonthStartTimeByDay() ? currentMonth : currentMonth + 1;
            return Triple.of((Object)false, needTime ? ActivityCommonUtils.getTime(now, month, timeLimitConf.getMonthStartTimeByDay(), timeLimitConf.getDayStartHour(), timeLimitConf.getDayStartMinute(), 0) : null, null);
        }
        if (ActivityCommonUtils.dayNotAllTime(timeLimitConf)) {
            return ActivityCommonUtils.calculateAccessTimeByDay(timeLimitConf, now, needTime, needTime ? ActivityCommonUtils.getNextMonthDayOffset(currentMonthDay, currentMonth, timeLimitConf, now) : 0);
        }
        return Triple.of((Object)true, null, needTime ? ActivityCommonUtils.getTime(now, currentMonth, timeLimitConf.getMonthEndTimeByDay(), timeLimitConf.getDayEndHour(), timeLimitConf.getDayEndMinute(), 59) : null);
    }

    private static int getNextMonthDayOffset(int currentMonthDay, int currentMonth, ActivityCommonTimeLimitConfDto timeLimitConf, Date now) {
        if (currentMonthDay < timeLimitConf.getMonthEndTimeByDay()) {
            return 1;
        }
        int currentDayOfYear = ActivityCommonUtils.getDateField(now, 6);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(2, currentMonth + 1);
        calendar.set(5, timeLimitConf.getMonthStartTimeByDay());
        return calendar.get(6) - currentDayOfYear;
    }

    private static int getDateField(Date now, int field) {
        Calendar calWeek = Calendar.getInstance();
        calWeek.setTime(now);
        return calWeek.get(field);
    }

    private static boolean dayNotAllTime(ActivityCommonTimeLimitConfDto timeLimitConf) {
        return timeLimitConf.getDayStartHour() != 0 || timeLimitConf.getDayStartMinute() != 0 || timeLimitConf.getDayEndHour() != 23 || timeLimitConf.getDayEndMinute() != 59;
    }

    public static Date getTime(Date date, Integer month, Integer dayOfMonth, Integer hour, Integer minute, Integer second) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (month != null) {
            calendar.set(2, month);
        }
        if (dayOfMonth != null) {
            calendar.set(5, dayOfMonth);
        }
        if (hour != null) {
            calendar.set(11, hour);
        }
        if (minute != null) {
            calendar.set(12, minute);
        }
        if (second != null) {
            calendar.set(13, second);
        }
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static List<Integer> getUserInfoEnumList(ActivityCommonDetailDto detailDto) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(ActivityCommonCacheTypeEnum.RECEIVE_RECORD.getType());
        typeList.add(ActivityCommonCacheTypeEnum.USER_TAKE_STAT.getType());
        typeList.add(ActivityCommonCacheTypeEnum.USER.getType());
        typeList.add(ActivityCommonCacheTypeEnum.USER_EXT.getType());
        if (ActivityCommonUtils.isOpenUserApiVerify(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.USER_API_VERIFY.getType());
        }
        if (ActivityCommonUtils.isOpenUserCustomVerify(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.USER_CUSTOM_VERIFY.getType());
        }
        if (ActivityCommonUtils.isOpenApiReachStandard(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.API_REACH_STANDARD.getType());
        }
        if (ActivityCommonUtils.isOpenSignUp(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.SIGN_UP_LIST.getType());
        }
        if (ActivityCommonUtils.isOpenSignUpCustomVerify(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.SIGN_UP_CUSTOM_VERIFY.getType());
        }
        if (ActivityCommonUtils.isOpenProcessingBizOrder(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.LAST_PAY_ORDER.getType());
        }
        if (ActivityCommonUtils.isOpenPay(detailDto)) {
            typeList.add(ActivityCommonCacheTypeEnum.PAY_ORDER_VOUCHER.getType());
        }
        return typeList;
    }

    public static String getUserMark(ActivityCommonDetailDto detailDto, UserDto userDto, Map<Integer, String> userExtMap) throws BizException {
        Integer userMarkType = ActivityCommonUtils.getUserMarkType(detailDto);
        if (userMarkType == null) {
            return null;
        }
        if (ActivityCommonBlackWhiteUserMarkTypeEnum.USER_PHONE.getType().equals(userMarkType)) {
            return MapUtils.isEmpty(userExtMap) ? null : userExtMap.get(UserExtCommonKeyEnum.USER_PHONE.getCode());
        }
        return null;
    }

    private static Integer getUserMarkType(ActivityCommonDetailDto detailDto) throws BizException {
        Integer blackUserMarkType;
        Integer whiteUserMarkType = ActivityCommonUtils.isOpenWhiteList(detailDto) ? detailDto.getWhiteConf().getUserMarkType() : null;
        Integer n = blackUserMarkType = ActivityCommonUtils.isOpenBlackList(detailDto) ? detailDto.getBlackConf().getUserMarkType() : null;
        if (whiteUserMarkType == null && blackUserMarkType == null) {
            return null;
        }
        if (whiteUserMarkType == null) {
            return blackUserMarkType;
        }
        if (blackUserMarkType == null) {
            return whiteUserMarkType;
        }
        if (!Objects.equals(whiteUserMarkType, blackUserMarkType)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000016);
            return null;
        }
        return whiteUserMarkType;
    }

    public static boolean isAllHitCache(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList) {
        boolean allHitCache = ActivityCommonUtils.isAllHitCache(detailDto, userInfoDto);
        if (!allHitCache) {
            return false;
        }
        return !ActivityCommonUtils.needLoadBlackWhiteList(detailDto, blackWhiteList);
    }

    public static boolean isAllHitCache(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (userInfoDto.getReceiveRecordList() == null || userInfoDto.getUserTakeStatList() == null || userInfoDto.getUserDto() == null || userInfoDto.getUserExtMap() == null) {
            return false;
        }
        if (ActivityCommonUtils.needLoadUserApiVerify(detailDto, userInfoDto)) {
            return false;
        }
        if (ActivityCommonUtils.needLoadUserCustomVerify(detailDto, userInfoDto)) {
            return false;
        }
        if (ActivityCommonUtils.needLoadApiReachStandard(detailDto, userInfoDto)) {
            return false;
        }
        if (ActivityCommonUtils.needLoadSignUp(detailDto, userInfoDto)) {
            return false;
        }
        if (ActivityCommonUtils.needLoadSignUpCustomVerify(detailDto, userInfoDto)) {
            return false;
        }
        if (ActivityCommonUtils.needLoadProcessingBizOrder(detailDto, userInfoDto)) {
            return false;
        }
        return !ActivityCommonUtils.needLoadPayOrderVoucher(detailDto, userInfoDto);
    }

    public static boolean needLoadUserApiVerify(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenUserApiVerify(detailDto)) {
            return false;
        }
        return userInfoDto.getUserApiVerify() == null || ActivityCommonUserVerifyStatusEnum.EXCEPTION.getStatus().equals(userInfoDto.getUserApiVerify().getStatus());
    }

    public static boolean isOpenUserApiVerify(ActivityCommonDetailDto detailDto) {
        if (detailDto.getUserLimit() == null) {
            return false;
        }
        return detailDto.getUserLimit().isNeedApiVerify();
    }

    public static boolean needLoadUserCustomVerify(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenUserCustomVerify(detailDto)) {
            return false;
        }
        return userInfoDto.getUserCustomVerify() == null || ActivityCommonUserVerifyStatusEnum.EXCEPTION.getStatus().equals(userInfoDto.getUserCustomVerify().getStatus());
    }

    public static boolean isOpenUserCustomVerify(ActivityCommonDetailDto detailDto) {
        if (detailDto.getUserLimit() == null) {
            return false;
        }
        return detailDto.getUserLimit().isNeedCustomVerify();
    }

    public static boolean needLoadApiReachStandard(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenApiReachStandard(detailDto)) {
            return false;
        }
        return userInfoDto.getApiReachStandard() == null || BooleanUtils.isNotTrue((Boolean)userInfoDto.getApiReachStandard().getSuccess());
    }

    public static boolean isOpenApiReachStandard(ActivityCommonDetailDto detailDto) {
        if (detailDto.getReachStandardConf() == null) {
            return false;
        }
        if (!BooleanEnum.TRUE.getCode().equals(detailDto.getReachStandardConf().getEnable())) {
            return false;
        }
        return ActivityCommonReachStandardTypeEnum.API.getType().equals(detailDto.getReachStandardConf().getType());
    }

    public static boolean needLoadSignUp(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenSignUp(detailDto)) {
            return false;
        }
        return userInfoDto.getSignUpList() == null;
    }

    public static boolean isOpenSignUp(ActivityCommonDetailDto detailDto) {
        if (detailDto.getSignUpConf() == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(detailDto.getSignUpConf().getEnable());
    }

    public static boolean needLoadSignUpCustomVerify(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenSignUpCustomVerify(detailDto)) {
            return false;
        }
        return userInfoDto.getCustomSignUpVerify() == null;
    }

    public static boolean isOpenSignUpCustomVerify(ActivityCommonDetailDto detailDto) {
        if (detailDto.getSignUpConf() == null) {
            return false;
        }
        if (!BooleanEnum.TRUE.getCode().equals(detailDto.getSignUpConf().getEnable())) {
            return false;
        }
        if (!BooleanEnum.TRUE.getCode().equals(detailDto.getSignUpConf().getEnableVerify())) {
            return false;
        }
        return ActivityCommonSignUpVerifyRuleTypeEnum.CUSTOM.getType().equals(detailDto.getSignUpConf().getVerifyRule());
    }

    public static boolean needLoadProcessingBizOrder(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenProcessingBizOrder(detailDto)) {
            return false;
        }
        return Objects.isNull(userInfoDto.getLastPayOrderOptional());
    }

    public static boolean isOpenProcessingBizOrder(ActivityCommonDetailDto detailDto) {
        if (!ActivityCommonUtils.isOpenPay(detailDto)) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(detailDto.getPayConf().getInterceptProcess());
    }

    public static boolean needLoadPayOrderVoucher(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        if (!ActivityCommonUtils.isOpenPay(detailDto)) {
            return false;
        }
        return userInfoDto.getPayOrderVoucherList() == null;
    }

    public static boolean isOpenPay(ActivityCommonDetailDto detailDto) {
        if (detailDto.getPayConf() == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(detailDto.getPayConf().getEnable());
    }

    public static boolean needLoadBlackWhiteList(ActivityCommonDetailDto detailDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList) {
        if (!ActivityCommonUtils.isOpenBlackList(detailDto) && !ActivityCommonUtils.isOpenWhiteList(detailDto)) {
            return false;
        }
        return blackWhiteList == null;
    }

    public static boolean isOpenBlackList(ActivityCommonDetailDto detailDto) {
        if (detailDto.getBlackConf() == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(detailDto.getBlackConf().getEnable());
    }

    public static boolean isOpenWhiteList(ActivityCommonDetailDto detailDto) {
        if (detailDto.getWhiteConf() == null) {
            return false;
        }
        return BooleanEnum.TRUE.getCode().equals(detailDto.getWhiteConf().getEnable());
    }

    public static ActivityCommonUserResultDto calculateResult(ActivityCommonDetailDto detailDto, Map<Long, ActivityPrizeStockDto> prizeStockMap, Map<Long, List<PrizePeriodStockDto>> prizePeriodStockMap, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList) throws BizException {
        if (detailDto == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000001);
            return null;
        }
        if (userInfoDto == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC001001);
            return null;
        }
        if (CollectionUtils.isEmpty(detailDto.getPrizeList())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000005);
            return null;
        }
        if (userInfoDto.getReceiveRecordList() == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002035);
            return null;
        }
        if (userInfoDto.getUserTakeStatList() == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002036);
            return null;
        }
        if (userInfoDto.getUserExtMap() == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002037);
            return null;
        }
        Date now = new Date();
        ActivityCommonUserResultDto resultDto = new ActivityCommonUserResultDto();
        resultDto.setActivityCanTake(new ActivityCommonUserResultCanTakeDto());
        resultDto.setPrizeList(ActivityCommonUtils.buildBasePrizeList(detailDto));
        ActivityCommonUtils.fillCanAccess(resultDto, detailDto, now);
        ActivityCommonUtils.fillInTake(resultDto, detailDto, now);
        ActivityCommonUtils.fillShowUserId(resultDto, detailDto, userInfoDto);
        resultDto.setInBlackList(ActivityCommonUtils.inBlackList(detailDto, blackWhiteList));
        ActivityCommonUtils.fillUserCheck(resultDto, detailDto, userInfoDto);
        ActivityCommonUtils.fillCanSignedUp(resultDto, detailDto.getSignUpConf(), userInfoDto.getSignUpList(), now);
        ActivityCommonUtils.fillSignUpVerify(resultDto, detailDto.getSignUpConf(), userInfoDto, now);
        boolean canParticipate = ActivityCommonUtils.fillActivityParticipate(resultDto, detailDto, blackWhiteList, now);
        if (!canParticipate) {
            return resultDto;
        }
        ActivityCommonUtils.fillPrizeParticipate(resultDto.getPrizeList(), detailDto, userInfoDto, blackWhiteList, now);
        ActivityCommonUtils.fillPrizeTakeNum(resultDto.getPrizeList(), detailDto, userInfoDto, blackWhiteList, now);
        ActivityCommonUtils.fillActivityTakeNum(resultDto, detailDto, userInfoDto, blackWhiteList, now);
        ActivityCommonUtils.fillPayOrderVoucher(resultDto, detailDto, userInfoDto);
        ActivityCommonUtils.fillProcessingBizOrderNo(resultDto, detailDto, userInfoDto);
        ActivityCommonUtils.fillSellOut(resultDto, detailDto, prizeStockMap, prizePeriodStockMap);
        ActivityCommonUtils.fillCanTakeCanPay(resultDto, detailDto);
        return resultDto;
    }

    private static void fillCanAccess(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, Date now) {
        try {
            ActivityCommonUtils.checkActivityCanAccess(detailDto, now);
            resultDto.setCanAccess(true);
            resultDto.setAccessErrCode("");
        }
        catch (BizException e) {
            resultDto.setCanAccess(false);
            resultDto.setAccessErrCode(e.getCode());
        }
    }

    private static void checkActivityCanAccess(ActivityDto detailDto, Date now) throws BizException {
        if (!BooleanEnum.TRUE.getCode().equals(detailDto.getActivityStatus())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002031);
            return;
        }
        if (detailDto.getStartTime() != null && now.before(detailDto.getStartTime())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002032);
            return;
        }
        if (detailDto.getEndTime() != null && now.after(detailDto.getEndTime())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002033);
        }
    }

    private static void fillInTake(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, Date now) {
        try {
            ActivityCommonUtils.checkActivityInTakeTime(detailDto, now);
            resultDto.setInTakeTime(true);
            resultDto.setTakeTimeErrCode("");
        }
        catch (BizException e) {
            resultDto.setInTakeTime(false);
            resultDto.setTakeTimeErrCode(e.getCode());
        }
    }

    private static void checkActivityInTakeTime(ActivityCommonDetailDto detailDto, Date now) throws BizException {
        if (detailDto.getTimeLimit() == null || !BooleanEnum.TRUE.getCode().equals(detailDto.getTimeLimit().getEnable())) {
            return;
        }
        Triple<Boolean, Date, Date> triple = ActivityCommonUtils.calculateAccessTime(detailDto.getTimeLimit(), now, false);
        if (BooleanUtils.isNotTrue((Boolean)((Boolean)triple.getLeft()))) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002034);
        }
    }

    private static void fillShowUserId(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        try {
            String showUserId = ActivityCommonUtils.getShowUserId(detailDto, userInfoDto);
            if (showUserId == null) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002030);
                return;
            }
            resultDto.setShowUserId(showUserId);
            resultDto.setShowUserIdErrCode("");
        }
        catch (BizException e) {
            resultDto.setShowUserId(null);
            resultDto.setShowUserIdErrCode(e.getCode());
        }
    }

    private static String getShowUserId(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) throws BizException {
        ActivityCommonInterfaceConfDto interfaceConf = detailDto.getInterfaceConf();
        if (interfaceConf == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002028);
            return null;
        }
        if (!BooleanEnum.TRUE.getCode().equals(interfaceConf.getShowUserId())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002028);
            return null;
        }
        if (ActivityCommonUserIdTypeEnum.USER_ID.getType().equals(interfaceConf.getUserIdType())) {
            return userInfoDto.getUserDto() == null ? null : userInfoDto.getUserDto().getId().toString();
        }
        if (ActivityCommonUserIdTypeEnum.UNION_ID.getType().equals(interfaceConf.getUserIdType())) {
            return userInfoDto.getUserDto() == null ? null : userInfoDto.getUserDto().getUnionId();
        }
        if (ActivityCommonUserIdTypeEnum.CORE_CLIENT_NUMBER.getType().equals(interfaceConf.getUserIdType())) {
            return userInfoDto.getUserExtMap() == null ? null : userInfoDto.getUserExtMap().get(UserExtCommonKeyEnum.CORE_CLIENT_NUMBER.getCode());
        }
        if (ActivityCommonUserIdTypeEnum.BANK_CLIENT_NUMBER.getType().equals(interfaceConf.getUserIdType())) {
            return userInfoDto.getUserExtMap() == null ? null : userInfoDto.getUserExtMap().get(UserExtCommonKeyEnum.BANK_CLIENT_NUMBER.getCode());
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002029);
        return null;
    }

    private static void fillSellOut(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, Map<Long, ActivityPrizeStockDto> prizeStockMap, Map<Long, List<PrizePeriodStockDto>> prizePeriodStockMap) {
        ActivityCommonUtils.fillPrizeSellOut(resultDto, detailDto, prizeStockMap, prizePeriodStockMap);
        ActivityCommonUtils.fillActivitySellOut(resultDto);
    }

    private static void fillActivitySellOut(ActivityCommonUserResultDto resultDto) {
        long count = resultDto.getPrizeList().stream().filter(prize -> !ActivityPrizeTypeEnum.THANKS.getType().equals(prize.getPrizeType()) && prize.getPrizeCanTake().getCanParticipate() != false && prize.getPrizeCanTake().getSellOut() == false).count();
        resultDto.getActivityCanTake().setSellOut(count == 0L);
    }

    private static void fillPrizeSellOut(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, Map<Long, ActivityPrizeStockDto> prizeStockMap, Map<Long, List<PrizePeriodStockDto>> prizePeriodStockMap) {
        Map prizeDetailMap = detailDto.getPrizeList().stream().collect(Collectors.toMap(ActivityPrizeDto::getId, Function.identity()));
        resultDto.getPrizeList().forEach(prizeResultDto -> {
            if (ActivityPrizeTypeEnum.THANKS.getType().equals(prizeResultDto.getPrizeType())) {
                prizeResultDto.getPrizeCanTake().setSellOut(false);
                return;
            }
            ActivityCommonPrizeDetailDto prizeDetailDto = (ActivityCommonPrizeDetailDto)prizeDetailMap.get(prizeResultDto.getPrizeId());
            ActivityPrizeStockDto stock = (ActivityPrizeStockDto)prizeStockMap.get(prizeResultDto.getPrizeId());
            long remainNum = stock.getTotalNum() - stock.getUsedNum();
            if (prizeDetailDto.getStockLimit() == null || !BooleanEnum.TRUE.getCode().equals(prizeDetailDto.getStockLimit().getEnable())) {
                prizeResultDto.getPrizeCanTake().setSellOut(remainNum <= 0L);
                return;
            }
            List periodStockList = (List)prizePeriodStockMap.get(prizeResultDto.getPrizeId());
            Long minPeriodStockNum = periodStockList.stream().map(s -> s.getTotalNum() - s.getUsedNum()).min(Long::compare).orElse(null);
            if (minPeriodStockNum == null || minPeriodStockNum >= remainNum) {
                prizeResultDto.getPrizeCanTake().setSellOut(remainNum <= 0L);
                return;
            }
            prizeResultDto.getPrizeCanTake().setSellOut(minPeriodStockNum <= 0L);
        });
    }

    private static void fillCanTakeCanPay(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto) {
        ActivityCommonUtils.fillPrizeCanTakeCanPay(resultDto.getSignUpVerify(), resultDto.getPrizeList(), detailDto);
        ActivityCommonUtils.fillActivityCanTakePay(resultDto, detailDto);
    }

    private static void fillPrizeCanTakeCanPay(Boolean signUpVerify, List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto) {
        boolean canNotPay = detailDto.getPayConf() == null || !BooleanEnum.TRUE.getCode().equals(detailDto.getPayConf().getEnable());
        Integer dimension = detailDto.getPayConf() == null ? null : detailDto.getPayConf().getDimension();
        for (ActivityCommonUserPrizeResultDto resultDto : prizeList) {
            ActivityCommonUtils.fillCanTakeCanPay(resultDto.getPrizeCanTake(), resultDto.getSurplusTakeNum(), canTakeDto -> {
                if (ActivityPrizeTypeEnum.THANKS.getType().equals(resultDto.getPrizeType())) {
                    return;
                }
                ActivityCommonUtils.checkCanTake(signUpVerify, resultDto, canNotPay, canTakeDto.getCanParticipate());
            }, canTakeDto -> {
                if (ActivityPrizeTypeEnum.THANKS.getType().equals(resultDto.getPrizeType())) {
                    ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002040);
                    return;
                }
                ActivityCommonUtils.checkCanPay(signUpVerify, resultDto, canNotPay, canTakeDto.getCanParticipate(), dimension);
            });
        }
    }

    private static void fillActivityCanTakePay(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto) {
        ActivityCommonUtils.fillCanTakeCanPay(resultDto.getActivityCanTake(), resultDto.getSurplusTakeNum(), canTakeDto -> ActivityCommonUtils.checkCanTake(resultDto), canTakeDto -> ActivityCommonUtils.checkCanPay(detailDto, resultDto.getSignUpVerify(), resultDto.getPrizeList()));
    }

    private static void checkCanTake(ActivityCommonUserResultDto resultDto) throws BizException {
        if (BooleanUtils.isFalse((Boolean)resultDto.getSignUpVerify())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002045);
            return;
        }
        long prizeCanTakeCount = resultDto.getPrizeList().stream().filter(prize -> BooleanUtils.isTrue((Boolean)prize.getPrizeCanTake().getCanTake())).count();
        if (prizeCanTakeCount < 1L) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002042);
        }
    }

    private static void checkCanPay(ActivityCommonDetailDto detailDto, Boolean signUpVerify, List<ActivityCommonUserPrizeResultDto> prizeList) throws BizException {
        boolean canNotPay;
        boolean bl = canNotPay = detailDto.getPayConf() == null || !BooleanEnum.TRUE.getCode().equals(detailDto.getPayConf().getEnable());
        if (canNotPay) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002024);
            return;
        }
        if (BooleanUtils.isFalse((Boolean)signUpVerify)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002045);
            return;
        }
        long prizeCanTakeCount = prizeList.stream().filter(prize -> BooleanUtils.isTrue((Boolean)prize.getPrizeCanTake().getCanTake()) && BooleanUtils.isFalse((Boolean)prize.getPrizeCanTake().getSellOut())).count();
        if (prizeCanTakeCount > 0L) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002043);
            return;
        }
        long canPayCount = prizeList.stream().filter(prize -> BooleanUtils.isTrue((Boolean)prize.getPrizeCanTake().getCanPay()) && BooleanUtils.isFalse((Boolean)prize.getPrizeCanTake().getSellOut()) && ActivityCommonUtils.noPayOrderTakeVoucher(prize)).count();
        if (canPayCount < 1L) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002044);
        }
    }

    private static void fillCanTakeCanPay(ActivityCommonUserResultCanTakeDto canTakeDto, Long surplusTakeNum, BizConsumer<ActivityCommonUserResultCanTakeDto> canTakeConsumer, BizConsumer<ActivityCommonUserResultCanTakeDto> canPayConsumer) {
        if (surplusTakeNum == 0L) {
            canTakeDto.setAllTake(true);
        }
        ActivityCommonUtils.fillCanTake(canTakeDto, canTakeConsumer);
        ActivityCommonUtils.fillCanPay(canTakeDto, canPayConsumer);
    }

    private static void fillCanTake(ActivityCommonUserResultCanTakeDto canTakeDto, BizConsumer<ActivityCommonUserResultCanTakeDto> consumer) {
        try {
            consumer.accept(canTakeDto);
            canTakeDto.setCanTake(true);
            canTakeDto.setTakeErrCode("");
        }
        catch (BizException e) {
            canTakeDto.setCanTake(false);
            canTakeDto.setTakeErrCode(e.getCode());
        }
    }

    private static void fillCanPay(ActivityCommonUserResultCanTakeDto canTakeDto, BizConsumer<ActivityCommonUserResultCanTakeDto> consumer) {
        try {
            consumer.accept(canTakeDto);
            canTakeDto.setCanPay(true);
            canTakeDto.setPayErrCode("");
        }
        catch (BizException e) {
            canTakeDto.setCanPay(false);
            canTakeDto.setPayErrCode(e.getCode());
        }
    }

    private static void checkCanPay(Boolean signUpVerify, ActivityCommonUserPrizeResultDto resultDto, boolean canNotPay, Boolean canParticipate, Integer dimension) throws BizException {
        if (canNotPay) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002024);
            return;
        }
        if (BooleanUtils.isNotTrue((Boolean)canParticipate)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002025);
            return;
        }
        if (BooleanUtils.isFalse((Boolean)signUpVerify)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002046);
            return;
        }
        if (resultDto.getSurplusTakeNum() == 0L) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002026);
            return;
        }
        if (ActivityCommonUtils.noPayOrderTakeVoucher(resultDto)) {
            return;
        }
        if (ActivityCommonDimensionEnum.PRIZE.getDimension().equals(dimension)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002027);
        }
    }

    private static boolean noPayOrderTakeVoucher(ActivityCommonUserPrizeResultDto resultDto) {
        return resultDto.getPayOrderTakeVoucherId() == null || resultDto.getPayOrderTakeVoucherId() <= 0L;
    }

    private static void checkCanTake(Boolean signUpVerify, ActivityCommonUserPrizeResultDto resultDto, boolean canNotPay, Boolean canParticipate) throws BizException {
        if (BooleanUtils.isNotTrue((Boolean)canParticipate)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002021);
            return;
        }
        if (BooleanUtils.isFalse((Boolean)signUpVerify)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002045);
            return;
        }
        if (resultDto.getSurplusTakeNum() == 0L) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002022);
            return;
        }
        if (canNotPay) {
            return;
        }
        if (ActivityCommonUtils.noPayOrderTakeVoucher(resultDto)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002023);
        }
    }

    private static void fillProcessingBizOrderNo(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) throws BizException {
        ActivityCommonPayConfDto payConf = detailDto.getPayConf();
        if (payConf == null || !BooleanEnum.TRUE.getCode().equals(payConf.getEnable())) {
            return;
        }
        Optional<PayOrderDto> lastPayOrderOptional = userInfoDto.getLastPayOrderOptional();
        if (Objects.nonNull(lastPayOrderOptional)) {
            resultDto.setProcessingBizOrderNo(lastPayOrderOptional.map(PayOrderDto::getBizOrderNo).orElse(null));
            return;
        }
        if (BooleanEnum.TRUE.getCode().equals(payConf.getInterceptProcess())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002038);
        }
    }

    private static void fillPayOrderVoucher(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) throws BizException {
        ActivityCommonPayConfDto payConf = detailDto.getPayConf();
        if (payConf == null || !BooleanEnum.TRUE.getCode().equals(payConf.getEnable())) {
            return;
        }
        List<PayOrderTakeVoucherCacheDto> payOrderVoucherList = userInfoDto.getPayOrderVoucherList();
        if (payOrderVoucherList == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002039);
            return;
        }
        if (CollectionUtils.isEmpty(payOrderVoucherList)) {
            return;
        }
        Map<Long, List<PayOrderTakeVoucherCacheDto>> payOrderVoucherMap = payOrderVoucherList.stream().collect(Collectors.groupingBy(PayOrderTakeVoucherCacheDto::getPrizeId));
        if (ActivityPrizeDrawTypeEnum.PROBABILITY.getType().equals(detailDto.getDrawType())) {
            resultDto.getPrizeList().forEach(prizeResult -> ActivityCommonUtils.fillPayOrderVoucher(prizeResult, (List)payOrderVoucherMap.get(0L)));
            return;
        }
        resultDto.getPrizeList().forEach(prizeResult -> ActivityCommonUtils.fillPayOrderVoucher(prizeResult, (List)payOrderVoucherMap.get(prizeResult.getPrizeId())));
    }

    private static void fillPayOrderVoucher(ActivityCommonUserPrizeResultDto prizeResult, List<PayOrderTakeVoucherCacheDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (ActivityPrizeTypeEnum.THANKS.getType().equals(prizeResult.getPrizeType())) {
            return;
        }
        PayOrderTakeVoucherCacheDto payOrderTakeVoucher = list.get(0);
        prizeResult.setPayOrderTakeVoucherId(payOrderTakeVoucher.getId());
        prizeResult.setPayOrderTakeVoucherTakeCount(payOrderTakeVoucher.getTakeCount());
        prizeResult.setPayOrderTakeVoucherRecordIds(payOrderTakeVoucher.getRecordIds());
        prizeResult.setBizOrderNo(payOrderTakeVoucher.getBizOrderNo());
    }

    private static void fillActivityTakeNum(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) throws BizException {
        long prizeTotalSurplusTakeNum = ActivityCommonUtils.getPrizeTotalSurplusTakeNum(resultDto);
        resultDto.setSurplusTakeNum(prizeTotalSurplusTakeNum);
        ActivityCommonUtils.fillActivityLimitSurplusTakeNum(resultDto, detailDto, userInfoDto, now);
        ActivityCommonUtils.fillActivityWhiteListSurplusTakeNum(resultDto, blackWhiteList);
    }

    private static void fillActivityLimitSurplusTakeNum(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, Date now) throws BizException {
        Map statMap = userInfoDto.getUserTakeStatList().stream().collect(Collectors.toMap(UserTakeStatCacheDto::getPrizeId, Function.identity()));
        UserTakeStatCacheDto stat = (UserTakeStatCacheDto)statMap.get(0L);
        if (stat != null) {
            resultDto.getActivityCanTake().setUserTakeStatId(stat.getId());
        }
        resultDto.getActivityCanTake().setTakeCount(Long.valueOf(userInfoDto.getReceiveRecordList().size()));
        resultDto.getActivityCanTake().setLastRecordId(ActivityCommonUtils.getMaxId(userInfoDto.getReceiveRecordList()));
        if (detailDto.getTakeNumLimit() == null || !BooleanEnum.TRUE.getCode().equals(detailDto.getTakeNumLimit().getEnable())) {
            return;
        }
        resultDto.setSurplusTakeNum(ActivityCommonUtils.getSurplusNum(resultDto.getSurplusTakeNum(), detailDto.getTakeNumLimit(), userInfoDto.getReceiveRecordList(), now));
    }

    private static void fillActivityWhiteListSurplusTakeNum(ActivityCommonUserResultDto resultDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList) {
        if (BooleanUtils.isNotTrue((Boolean)resultDto.getActivityCanTake().getInWhiteList())) {
            return;
        }
        if (resultDto.getActivityCanTake().getWhiteListId() == null || resultDto.getActivityCanTake().getWhiteListId() <= 0L) {
            resultDto.setSurplusTakeNum(0L);
            return;
        }
        Map whiteListMap = blackWhiteList.stream().collect(Collectors.toMap(ActivityBlackWhiteListCacheDto::getId, Function.identity()));
        ActivityBlackWhiteListCacheDto whiteListCacheDto = (ActivityBlackWhiteListCacheDto)whiteListMap.get(resultDto.getActivityCanTake().getWhiteListId());
        if (resultDto.getSurplusTakeNum() == null || resultDto.getSurplusTakeNum() < 0L) {
            resultDto.setSurplusTakeNum(whiteListCacheDto.getTotalNum() - whiteListCacheDto.getUsedNum());
            return;
        }
        resultDto.setSurplusTakeNum(Math.min(resultDto.getSurplusTakeNum(), whiteListCacheDto.getTotalNum() - whiteListCacheDto.getUsedNum()));
    }

    private static long getPrizeTotalSurplusTakeNum(ActivityCommonUserResultDto resultDto) {
        if (resultDto.getPrizeList().stream().filter(prize -> !ActivityPrizeTypeEnum.THANKS.getType().equals(prize.getPrizeType())).anyMatch(prize -> prize.getSurplusTakeNum() < 0L)) {
            return -1L;
        }
        return resultDto.getPrizeList().stream().filter(prize -> !ActivityPrizeTypeEnum.THANKS.getType().equals(prize.getPrizeType())).mapToLong(ActivityCommonUserPrizeResultDto::getSurplusTakeNum).sum();
    }

    private static void fillPrizeTakeNum(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) throws BizException {
        ActivityCommonUtils.fillPrizeLimitSurplusTakeNum(prizeList, detailDto, userInfoDto, now);
        ActivityCommonUtils.fillPrizeWhiteListSurplusTakeNum(prizeList, blackWhiteList);
    }

    private static void fillPrizeWhiteListSurplusTakeNum(List<ActivityCommonUserPrizeResultDto> prizeList, List<ActivityBlackWhiteListCacheDto> blackWhiteList) {
        Map whiteListMap = blackWhiteList.stream().collect(Collectors.toMap(ActivityBlackWhiteListCacheDto::getId, Function.identity()));
        prizeList.stream().filter(prize -> BooleanUtils.isTrue((Boolean)prize.getPrizeCanTake().getInWhiteList())).collect(Collectors.toList()).forEach(prize -> {
            if (prize.getPrizeCanTake().getWhiteListId() == null || prize.getPrizeCanTake().getWhiteListId() <= 0L) {
                prize.setSurplusTakeNum(0L);
                return;
            }
            ActivityBlackWhiteListCacheDto whiteListCacheDto = (ActivityBlackWhiteListCacheDto)whiteListMap.get(prize.getPrizeCanTake().getWhiteListId());
            prize.setGrantAmount(whiteListCacheDto.getGrantAmount());
            if (prize.getSurplusTakeNum() == null || prize.getSurplusTakeNum() < 0L) {
                prize.setSurplusTakeNum(whiteListCacheDto.getTotalNum() - whiteListCacheDto.getUsedNum());
                return;
            }
            prize.setSurplusTakeNum(Math.min(prize.getSurplusTakeNum(), whiteListCacheDto.getTotalNum() - whiteListCacheDto.getUsedNum()));
        });
    }

    private static void fillPrizeLimitSurplusTakeNum(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, Date now) throws BizException {
        Map<Long, List<ActivityPrizeReceiveRecordCacheDto>> recordMap = userInfoDto.getReceiveRecordList().stream().collect(Collectors.groupingBy(ActivityPrizeReceiveRecordCacheDto::getActivityPrizeId));
        Map statMap = userInfoDto.getUserTakeStatList().stream().collect(Collectors.toMap(UserTakeStatCacheDto::getPrizeId, Function.identity()));
        Map prizeMap = detailDto.getPrizeList().stream().collect(Collectors.toMap(ActivityPrizeDto::getId, Function.identity()));
        for (ActivityCommonUserPrizeResultDto prize : prizeList) {
            UserTakeStatCacheDto stat = (UserTakeStatCacheDto)statMap.get(prize.getPrizeId());
            if (stat != null) {
                prize.getPrizeCanTake().setUserTakeStatId(stat.getId());
            }
            List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList = recordMap.get(prize.getPrizeId());
            prize.getPrizeCanTake().setTakeCount(receiveRecordList == null ? 0L : (long)receiveRecordList.size());
            prize.getPrizeCanTake().setLastRecordId(ActivityCommonUtils.getMaxId(receiveRecordList));
            ActivityCommonPrizeDetailDto prizeDetail = (ActivityCommonPrizeDetailDto)prizeMap.get(prize.getPrizeId());
            if (prizeDetail.getTakeNumLimit() == null || !BooleanEnum.TRUE.getCode().equals(prizeDetail.getTakeNumLimit().getEnable())) {
                return;
            }
            prize.setSurplusTakeNum(ActivityCommonUtils.getSurplusNum(prize.getSurplusTakeNum(), prizeDetail.getTakeNumLimit(), receiveRecordList, now));
        }
    }

    private static Long getSurplusNum(Long surplusTakeNum, ActivityCommonTakeLimitConfDto takeLimitConfDto, List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList, Date now) throws BizException {
        List<ActivityCommonTakeLimitConfDetailDto> detailList = takeLimitConfDto.getDetailList();
        long surplusNum = surplusTakeNum == null ? -1L : surplusTakeNum;
        for (ActivityCommonTakeLimitConfDetailDto detail : detailList) {
            ActivityPeriodicUnitEnum periodicUnitEnum = ActivityPeriodicUnitEnum.getByCode(detail.getPeriodicUnit());
            if (periodicUnitEnum == null) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
                return null;
            }
            ActivityPeriodicDto periodicDto = periodicUnitEnum.getDate(now, detail.getAbsoluteStartTime(), detail.getAbsoluteEndTime());
            if (periodicDto == null) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC000015);
                return null;
            }
            long usedNum = ActivityCommonUtils.getUsedNum(periodicDto, receiveRecordList);
            long periodicSurplusNum = (long)detail.getTakeNum().intValue() - usedNum;
            if (periodicSurplusNum <= 0L) {
                surplusNum = 0L;
                continue;
            }
            if (surplusNum < 0L) {
                surplusNum = periodicSurplusNum;
                continue;
            }
            surplusNum = Math.min(surplusNum, periodicSurplusNum);
        }
        return surplusNum;
    }

    private static long getUsedNum(ActivityPeriodicDto periodicDto, List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList) {
        if (receiveRecordList == null) {
            return 0L;
        }
        if (periodicDto.getBeginDate() == null || periodicDto.getEndDate() == null) {
            return receiveRecordList.size();
        }
        return receiveRecordList.stream().filter(r -> periodicDto.getBeginDate().before(r.getGmtCreate()) && periodicDto.getEndDate().after(r.getGmtCreate())).count();
    }

    private static Long getMaxId(List<ActivityPrizeReceiveRecordCacheDto> receiveRecordList) {
        if (receiveRecordList == null) {
            return null;
        }
        ActivityPrizeReceiveRecordCacheDto maxIdDto = receiveRecordList.stream().max(Comparator.comparing(ActivityPrizeReceiveRecordCacheDto::getId)).orElse(null);
        if (maxIdDto == null) {
            return null;
        }
        return maxIdDto.getId();
    }

    private static List<ActivityCommonUserPrizeResultDto> buildBasePrizeList(ActivityCommonDetailDto detailDto) {
        Map<Long, List<ActivityCommonPrizeDetailDto>> parentPrizeMap = detailDto.getPrizeList().stream().collect(Collectors.groupingBy(ActivityPrizeDto::getParentPrizeId));
        return detailDto.getPrizeList().stream().map(prizeDetailDto -> {
            if (ActivityPrizeTypeEnum.EQUITY_SUB.getType().equals(prizeDetailDto.getPrizeType())) {
                return null;
            }
            ActivityCommonUserPrizeResultDto resultDto = new ActivityCommonUserPrizeResultDto();
            resultDto.setPrizeId(prizeDetailDto.getId());
            resultDto.setPrizeCanTake(new ActivityCommonUserResultCanTakeDto());
            resultDto.getPrizeCanTake().setCanParticipate(true);
            resultDto.getPrizeCanTake().setParticipateErrCode("");
            resultDto.setSurplusTakeNum(-1L);
            List subList = (List)parentPrizeMap.get(prizeDetailDto.getId());
            if (CollectionUtils.isEmpty((Collection)subList)) {
                return resultDto;
            }
            List<ActivityCommonUserResultSubPrizeDto> subPrizeList = subList.stream().map(subPrize -> {
                ActivityCommonUserResultSubPrizeDto subResultDto = new ActivityCommonUserResultSubPrizeDto();
                subResultDto.setPrizeId(subPrize.getId());
                return subResultDto;
            }).collect(Collectors.toList());
            resultDto.setSubPrizeList(subPrizeList);
            return resultDto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void fillPrizeParticipate(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) {
        ActivityCommonUtils.checkPrizeWhiteList(prizeList, detailDto, blackWhiteList, now);
        ActivityCommonUtils.checkPrizeReachStandard(prizeList, detailDto, userInfoDto, blackWhiteList, now);
    }

    private static void checkPrizeReachStandard(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) {
        ActivityCommonReachStandardConfDto reachStandardConf = detailDto.getReachStandardConf();
        if (reachStandardConf == null || !BooleanEnum.TRUE.getCode().equals(reachStandardConf.getEnable())) {
            return;
        }
        if (ActivityCommonReachStandardTypeEnum.WHITE_LIST.getType().equals(reachStandardConf.getType())) {
            ActivityCommonUtils.checkPrizeReachStandardByWhiteList(prizeList, reachStandardConf, blackWhiteList, now);
            return;
        }
        ActivityCommonUtils.checkPrizeReachStandardByApi(prizeList, reachStandardConf, userInfoDto);
    }

    private static void checkPrizeReachStandardByApi(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonReachStandardConfDto reachStandardConf, ActivityCommonUserInfoCacheDto userInfoDto) {
        ActivityCommonReachStandardDto apiReachStandard = userInfoDto.getApiReachStandard();
        if (apiReachStandard == null || BooleanUtils.isNotTrue((Boolean)userInfoDto.getApiReachStandard().getSuccess())) {
            ActivityCommonUtils.prizeAllCanNotParticipate(prizeList, ActivityCommonErrorCodeEnum.AC002018);
            return;
        }
        if (apiReachStandard.getLevel() == null) {
            ActivityCommonUtils.prizeAllCanNotParticipate(prizeList, ActivityCommonErrorCodeEnum.AC002019);
            return;
        }
        Map<Object, Object> levelPrizeIdsMap = reachStandardConf.getApiList() == null ? Collections.emptyMap() : reachStandardConf.getApiList().stream().collect(Collectors.toMap(ActivityCommonReachStandardApiConfDto::getLevel, ActivityCommonReachStandardApiConfDto::getPrizeIds));
        List prizeIds = (List)levelPrizeIdsMap.get(apiReachStandard.getLevel());
        if (CollectionUtils.isEmpty((Collection)prizeIds)) {
            ActivityCommonUtils.prizeAllCanNotParticipate(prizeList, ActivityCommonErrorCodeEnum.AC002019);
            return;
        }
        prizeList.stream().filter(resultDto -> BooleanUtils.isNotFalse((Boolean)resultDto.getPrizeCanTake().getCanParticipate())).collect(Collectors.toList()).forEach(resultDto -> {
            if (!prizeIds.contains(resultDto.getPrizeId())) {
                ActivityCommonUtils.fillPrizeParticipateErr(resultDto, ActivityCommonErrorCodeEnum.AC002020.name());
            }
        });
    }

    private static void prizeAllCanNotParticipate(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonErrorCodeEnum errorCodeEnum) {
        prizeList.stream().filter(resultDto -> BooleanUtils.isNotFalse((Boolean)resultDto.getPrizeCanTake().getCanParticipate())).collect(Collectors.toList()).forEach(resultDto -> ActivityCommonUtils.fillPrizeParticipateErr(resultDto, errorCodeEnum.name()));
    }

    private static void checkPrizeReachStandardByWhiteList(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonReachStandardConfDto reachStandardConf, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) {
        Map<Long, List<ActivityBlackWhiteListCacheDto>> prizeWhiteListMap = blackWhiteList.stream().filter(list -> ActivityCommonUtils.isEffectiveWhiteList(list, now)).collect(Collectors.groupingBy(ActivityBlackWhiteListCacheDto::getReachStandardAmount));
        Map reachStandardWhiteListMap = reachStandardConf.getWhiteListList() == null ? Collections.emptyMap() : reachStandardConf.getWhiteListList().stream().collect(Collectors.groupingBy(ActivityCommonReachStandardWhiteListConfDto::getPrizeId, Collectors.mapping(ActivityCommonReachStandardWhiteListConfDto::getAmount, Collectors.toList())));
        prizeList.stream().filter(resultDto -> BooleanUtils.isNotFalse((Boolean)resultDto.getPrizeCanTake().getCanParticipate())).collect(Collectors.toList()).forEach(resultDto -> {
            List amountList = (List)reachStandardWhiteListMap.get(resultDto.getPrizeId());
            List<ActivityBlackWhiteListCacheDto> whiteList = amountList.stream().filter(prizeWhiteListMap::containsKey).flatMap(amount -> ((List)prizeWhiteListMap.get(amount)).stream()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(whiteList)) {
                ActivityCommonUtils.fillPrizeParticipateErr(resultDto, ActivityCommonErrorCodeEnum.AC002017.name());
            } else {
                Long earliestExpiredWhitelist = ActivityCommonUtils.getEarliestExpiredWhitelist(whiteList);
                resultDto.getPrizeCanTake().setWhiteListId(earliestExpiredWhitelist);
                resultDto.getPrizeCanTake().setInWhiteList(true);
            }
        });
    }

    private static void checkPrizeWhiteList(List<ActivityCommonUserPrizeResultDto> prizeList, ActivityCommonDetailDto detailDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) {
        ActivityCommonWhiteConfDto whiteConf = detailDto.getWhiteConf();
        if (whiteConf == null || !BooleanEnum.TRUE.getCode().equals(whiteConf.getEnable())) {
            return;
        }
        if (ActivityCommonDimensionEnum.ACTIVITY.getDimension().equals(whiteConf.getDimension())) {
            return;
        }
        Map<Long, List<ActivityBlackWhiteListCacheDto>> prizeWhiteListMap = blackWhiteList.stream().filter(list -> ActivityCommonUtils.isEffectiveWhiteList(list, now)).collect(Collectors.groupingBy(ActivityBlackWhiteListCacheDto::getPrizeId));
        prizeList.stream().filter(resultDto -> BooleanUtils.isNotFalse((Boolean)resultDto.getPrizeCanTake().getCanParticipate())).collect(Collectors.toList()).forEach(resultDto -> {
            List whiteList = (List)prizeWhiteListMap.get(resultDto.getPrizeId());
            if (CollectionUtils.isEmpty((Collection)whiteList)) {
                ActivityCommonUtils.fillPrizeParticipateErr(resultDto, ActivityCommonErrorCodeEnum.AC002016.name());
            } else {
                Long earliestExpiredWhitelist = ActivityCommonUtils.getEarliestExpiredWhitelist(whiteList);
                resultDto.getPrizeCanTake().setWhiteListId(earliestExpiredWhitelist);
                resultDto.getPrizeCanTake().setInWhiteList(true);
            }
        });
    }

    private static Long getEarliestExpiredWhitelist(List<ActivityBlackWhiteListCacheDto> whiteList) {
        ActivityBlackWhiteListCacheDto whiteListCacheDto = whiteList.stream().filter(list -> list.getTotalNum() > list.getUsedNum()).min(Comparator.comparing(ActivityBlackWhiteListCacheDto::getEndTime)).orElse(null);
        if (whiteListCacheDto == null) {
            return null;
        }
        return whiteListCacheDto.getId();
    }

    private static void fillPrizeParticipateErr(ActivityCommonUserPrizeResultDto resultDto, String code) {
        if (ActivityPrizeTypeEnum.THANKS.getType().equals(resultDto.getPrizeType())) {
            return;
        }
        resultDto.getPrizeCanTake().setCanParticipate(false);
        resultDto.getPrizeCanTake().setParticipateErrCode(code);
    }

    private static void fillCanSignedUp(ActivityCommonUserResultDto resultDto, ActivityCommonSignUpConfDto signUpConf, List<ActivitySignUpCacheDto> signUpList, Date now) {
        try {
            ActivityPeriodicDto nowPeriodic = ActivityCommonUtils.getNowPeriodic(signUpConf, now);
            Pair<Boolean, Long> pair = ActivityCommonUtils.getSignUpAndId(nowPeriodic, signUpList);
            resultDto.setSignedUp((Boolean)pair.getLeft());
            resultDto.setSignUpId((Long)pair.getRight());
            if (BooleanUtils.isTrue((Boolean)resultDto.getSignedUp())) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002052);
                return;
            }
            if (BooleanUtils.isNotTrue((Boolean)resultDto.getCanAccess())) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002048);
                return;
            }
            if (BooleanUtils.isTrue((Boolean)resultDto.getInBlackList())) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002050);
                return;
            }
            if (BooleanUtils.isNotTrue((Boolean)resultDto.getUserCheckPass())) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002051);
                return;
            }
            resultDto.setCanSignedUp(true);
            resultDto.setSignUpErrCode("");
        }
        catch (BizException e) {
            resultDto.setCanSignedUp(false);
            resultDto.setSignUpErrCode(e.getCode());
        }
    }

    private static ActivityPeriodicDto getNowPeriodic(ActivityCommonSignUpConfDto signUpConf, Date now) throws BizException {
        if (signUpConf == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002047);
            return null;
        }
        if (!BooleanEnum.TRUE.getCode().equals(signUpConf.getEnable())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002047);
            return null;
        }
        ActivityPeriodicDto nowPeriodic = ActivityCommonUtils.getNowPeriodic(now, signUpConf);
        if (nowPeriodic == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002049);
            return null;
        }
        return nowPeriodic;
    }

    private static Pair<Boolean, Long> getSignUpAndId(ActivityPeriodicDto periodic, List<ActivitySignUpCacheDto> signUpList) {
        if (CollectionUtils.isEmpty(signUpList)) {
            return Pair.of((Object)false, null);
        }
        if (periodic.getBeginDate() == null || periodic.getEndDate() == null) {
            return Pair.of((Object)true, (Object)signUpList.get(0).getId());
        }
        List inTimeList = signUpList.stream().filter(cache -> periodic.getBeginDate().before(cache.getGmtCreate()) && periodic.getEndDate().after(cache.getGmtCreate())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inTimeList)) {
            return Pair.of((Object)false, null);
        }
        return Pair.of((Object)true, (Object)((ActivitySignUpCacheDto)inTimeList.get(0)).getId());
    }

    private static ActivityPeriodicDto getNowPeriodic(Date now, ActivityCommonSignUpConfDto signUpConf) throws BizException {
        ActivityPeriodicUnitEnum periodicUnitEnum = ActivityPeriodicUnitEnum.getByCode(signUpConf.getPeriodicUnit());
        if (periodicUnitEnum == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002010);
            return null;
        }
        if (periodicUnitEnum == ActivityPeriodicUnitEnum.ABSOLUTE) {
            return ActivityCommonUtils.getNowAbsolute(now, signUpConf);
        }
        return periodicUnitEnum.getDate(now, null, null);
    }

    private static ActivityPeriodicDto getLastPeriodic(Date now, ActivityCommonSignUpConfDto signUpConf) throws BizException {
        ActivityPeriodicUnitEnum periodicUnitEnum = ActivityPeriodicUnitEnum.getByCode(signUpConf.getPeriodicUnit());
        if (periodicUnitEnum == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002010);
            return null;
        }
        if (periodicUnitEnum == ActivityPeriodicUnitEnum.ABSOLUTE) {
            return ActivityCommonUtils.getLastAbsolute(now, signUpConf);
        }
        return periodicUnitEnum.getOffsetPeriod(-1);
    }

    private static ActivityPeriodicDto getNowAbsolute(Date now, ActivityCommonSignUpConfDto signUpConf) {
        if (CollectionUtils.isEmpty(signUpConf.getAbsoluteTimeLimit())) {
            return null;
        }
        ActivityCommonTimeLimitAbsoluteConfDto timeLimit = signUpConf.getAbsoluteTimeLimit().stream().filter(time -> time.getAbsoluteStartTime().before(now) && time.getAbsoluteEndTime().after(now)).max(Comparator.comparing(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteStartTime)).orElse(null);
        if (timeLimit == null) {
            return null;
        }
        return new ActivityPeriodicDto(null, timeLimit.getAbsoluteStartTime(), timeLimit.getAbsoluteEndTime());
    }

    private static ActivityPeriodicDto getLastAbsolute(Date now, ActivityCommonSignUpConfDto signUpConf) {
        if (CollectionUtils.isEmpty(signUpConf.getAbsoluteTimeLimit())) {
            return null;
        }
        ActivityCommonTimeLimitAbsoluteConfDto timeLimit = signUpConf.getAbsoluteTimeLimit().stream().filter(time -> time.getAbsoluteEndTime().before(now)).max(Comparator.comparing(ActivityCommonTimeLimitAbsoluteConfDto::getAbsoluteEndTime)).orElse(null);
        if (timeLimit == null) {
            return null;
        }
        return new ActivityPeriodicDto(null, timeLimit.getAbsoluteStartTime(), timeLimit.getAbsoluteEndTime());
    }

    private static boolean fillActivityParticipate(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) {
        try {
            if (BooleanUtils.isNotTrue((Boolean)resultDto.getUserCheckPass())) {
                ActivityCommonUtils.throwBiz(resultDto.getUserCheckErrCode());
                return false;
            }
            if (BooleanUtils.isTrue((Boolean)resultDto.getInBlackList())) {
                ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002008);
                return false;
            }
            ActivityCommonUtils.checkInWhiteList(resultDto.getActivityCanTake(), detailDto, blackWhiteList, now);
            resultDto.getActivityCanTake().setCanParticipate(true);
            resultDto.getActivityCanTake().setParticipateErrCode("");
        }
        catch (BizException e) {
            resultDto.getActivityCanTake().setCanParticipate(false);
            resultDto.getActivityCanTake().setParticipateErrCode(e.getCode());
        }
        return resultDto.getActivityCanTake().getCanParticipate();
    }

    private static void fillSignUpVerify(ActivityCommonUserResultDto resultDto, ActivityCommonSignUpConfDto signUpConf, ActivityCommonUserInfoCacheDto userInfoDto, Date now) {
        if (signUpConf == null) {
            return;
        }
        if (!BooleanEnum.TRUE.getCode().equals(signUpConf.getEnable()) || !BooleanEnum.TRUE.getCode().equals(signUpConf.getEnableVerify())) {
            return;
        }
        try {
            ActivityCommonUtils.signUpVerify(resultDto, signUpConf, userInfoDto, now);
            resultDto.setSignUpVerify(true);
            resultDto.setSignUpVerifyErrCode("");
        }
        catch (BizException e) {
            resultDto.setSignUpVerify(false);
            resultDto.setSignUpVerifyErrCode(e.getCode());
        }
    }

    private static void signUpVerify(ActivityCommonUserResultDto resultDto, ActivityCommonSignUpConfDto signUpConf, ActivityCommonUserInfoCacheDto userInfoDto, Date now) throws BizException {
        if (ActivityCommonSignUpVerifyRuleTypeEnum.CURRENT_PERIOD.getType().equals(signUpConf.getVerifyRule())) {
            ActivityCommonUtils.checkSignUpVerifyCurrentPeriod(resultDto);
            return;
        }
        if (ActivityCommonSignUpVerifyRuleTypeEnum.CUSTOM.getType().equals(signUpConf.getVerifyRule())) {
            ActivityCommonUtils.checkCustomSignUpVerify(resultDto, userInfoDto.getCustomSignUpVerify());
            return;
        }
        ActivityCommonUtils.checkSignUpVerifyLastPeriod(resultDto, signUpConf, userInfoDto.getSignUpList(), now);
    }

    private static void checkSignUpVerifyLastPeriod(ActivityCommonUserResultDto resultDto, ActivityCommonSignUpConfDto signUpConf, List<ActivitySignUpCacheDto> signUpList, Date now) throws BizException {
        ActivityPeriodicDto lastPeriodic = ActivityCommonUtils.getLastPeriodic(now, signUpConf);
        if (lastPeriodic == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002014);
            return;
        }
        if (CollectionUtils.isEmpty(signUpList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002015);
            return;
        }
        if (lastPeriodic.getBeginDate() == null || lastPeriodic.getEndDate() == null) {
            resultDto.setSignUpId(signUpList.get(0).getId());
            return;
        }
        List inTimeList = signUpList.stream().filter(cache -> lastPeriodic.getBeginDate().before(cache.getGmtCreate()) && lastPeriodic.getEndDate().after(cache.getGmtCreate())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inTimeList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002015);
            return;
        }
        resultDto.setSignUpId(((ActivitySignUpCacheDto)inTimeList.get(0)).getId());
    }

    private static void checkSignUpVerifyCurrentPeriod(ActivityCommonUserResultDto resultDto) throws BizException {
        if (BooleanUtils.isNotTrue((Boolean)resultDto.getSignedUp())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002013);
        }
    }

    private static void checkCustomSignUpVerify(ActivityCommonUserResultDto resultDto, ActivityCommonCustomSignUpVerifyDto customSignUpVerify) throws BizException {
        if (customSignUpVerify == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002011);
            return;
        }
        if (ActivityCommonUserVerifyStatusEnum.PASSED.getStatus().equals(customSignUpVerify.getStatus())) {
            resultDto.setSignUpId(customSignUpVerify.getSignUpId());
            return;
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002012);
    }

    private static void fillUserCheck(ActivityCommonUserResultDto resultDto, ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) {
        try {
            ActivityCommonUtils.checkUserLimit(detailDto, userInfoDto);
            resultDto.setUserCheckPass(true);
            resultDto.setUserCheckErrCode("");
        }
        catch (BizException e) {
            resultDto.setUserCheckPass(false);
            resultDto.setUserCheckErrCode(e.getCode());
        }
    }

    private static void checkUserLimit(ActivityCommonDetailDto detailDto, ActivityCommonUserInfoCacheDto userInfoDto) throws BizException {
        ActivityCommonUserLimitConfDto userLimit = detailDto.getUserLimit();
        if (userLimit == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002001);
            return;
        }
        ActivityCommonUtils.checkUserType(userLimit, userInfoDto.getUserDto());
        ActivityCommonUtils.checkUserApiVerify(userLimit, userInfoDto.getUserApiVerify());
        ActivityCommonUtils.checkUserCustomVerify(userLimit, userInfoDto.getUserCustomVerify());
    }

    private static void checkUserType(ActivityCommonUserLimitConfDto userLimit, UserDto userDto) throws BizException {
        if (userDto == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC001002);
            return;
        }
        if (CollectionUtils.isEmpty(userLimit.getUserTypeList())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002006);
            return;
        }
        if (!userLimit.getUserTypeList().contains(userDto.getUserType())) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002007);
        }
    }

    private static void checkUserCustomVerify(ActivityCommonUserLimitConfDto userLimit, ActivityCommonUserCustomVerifyDto userCustomVerify) throws BizException {
        if (!userLimit.isNeedCustomVerify()) {
            return;
        }
        if (userCustomVerify == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002004);
            return;
        }
        if (ActivityCommonUserVerifyStatusEnum.PASSED.getStatus().equals(userCustomVerify.getStatus())) {
            return;
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002005);
    }

    private static void checkUserApiVerify(ActivityCommonUserLimitConfDto userLimit, ActivityCommonUserApiVerifyDto userApiVerify) throws BizException {
        if (!userLimit.isNeedApiVerify()) {
            return;
        }
        if (userApiVerify == null) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002002);
            return;
        }
        if (ActivityCommonUserVerifyStatusEnum.PASSED.getStatus().equals(userApiVerify.getStatus())) {
            return;
        }
        ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002003);
    }

    private static void checkInWhiteList(ActivityCommonUserResultCanTakeDto activityCanTake, ActivityCommonDetailDto detailDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList, Date now) throws BizException {
        ActivityCommonWhiteConfDto whiteConf = detailDto.getWhiteConf();
        if (whiteConf == null) {
            return;
        }
        if (!BooleanEnum.TRUE.getCode().equals(whiteConf.getEnable())) {
            return;
        }
        if (CollectionUtils.isEmpty(blackWhiteList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002009);
            return;
        }
        List<ActivityBlackWhiteListCacheDto> whiteList = blackWhiteList.stream().filter(list -> ActivityCommonUtils.isEffectiveWhiteList(list, now)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whiteList)) {
            ActivityCommonUtils.throwBiz(ActivityCommonErrorCodeEnum.AC002009);
            return;
        }
        if (!ActivityCommonDimensionEnum.ACTIVITY.getDimension().equals(whiteConf.getDimension()) || BooleanEnum.TRUE.getCode().equals(whiteConf.getLimitReachStandardAmount())) {
            return;
        }
        Long earliestExpiredWhitelist = ActivityCommonUtils.getEarliestExpiredWhitelist(whiteList);
        activityCanTake.setWhiteListId(earliestExpiredWhitelist);
        activityCanTake.setInWhiteList(true);
    }

    private static boolean isEffectiveWhiteList(ActivityBlackWhiteListCacheDto list, Date now) {
        return ActivityBlackWhiteListTypeEnum.WHITE.getType().equals(list.getListType()) && list.getStartTime().before(now) && list.getEndTime().after(now);
    }

    private static boolean inBlackList(ActivityCommonDetailDto detailDto, List<ActivityBlackWhiteListCacheDto> blackWhiteList) {
        ActivityCommonBlackConfDto blackConf = detailDto.getBlackConf();
        if (blackConf == null) {
            return false;
        }
        if (!BooleanEnum.TRUE.getCode().equals(blackConf.getEnable())) {
            return false;
        }
        if (CollectionUtils.isEmpty(blackWhiteList)) {
            return false;
        }
        long count = blackWhiteList.stream().filter(list -> ActivityBlackWhiteListTypeEnum.BLACK.getType().equals(list.getListType())).count();
        return count >= 1L;
    }
}

