/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.redis;

import cn.com.duiba.wolf.redis.RedisLock;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class AutomaticRenewalRedisLock
implements RedisLock {
    private static final Logger log = LoggerFactory.getLogger(AutomaticRenewalRedisLock.class);
    private StringRedisTemplate stringRedisTemplate;
    private String key;
    private String expectedValue;
    private long threadId;
    private volatile boolean running;
    private static final String COMPARE_AND_DELETE = "if redis.call('get',KEYS[1]) == ARGV[1]\nthen\n    return redis.call('del',KEYS[1])\nelse\n    return 0\nend";

    public AutomaticRenewalRedisLock(StringRedisTemplate stringRedisTemplate, String key, String expectedValue, long expireSeconds, long interval) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.key = key;
        this.expectedValue = expectedValue;
        this.threadId = Thread.currentThread().getId();
        this.running = true;
        new Thread(() -> {
            long intervalTime = TimeUnit.MILLISECONDS.convert(interval, TimeUnit.SECONDS);
            while (this.running) {
                try {
                    Thread.sleep(intervalTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().isInterrupted();
                }
                stringRedisTemplate.expire((Object)key, expireSeconds, TimeUnit.SECONDS);
                log.info("TestLog, expire, key={}, expireSeconds={}", (Object)key, (Object)expireSeconds);
            }
            log.info("TestLog, expire, end, key={}, expireSeconds={}", (Object)key, (Object)expireSeconds);
        }).start();
    }

    public void unlock() {
        if (Thread.currentThread().getId() != this.threadId) {
            throw new IllegalMonitorStateException();
        }
        this.running = false;
        List<String> keys = Collections.singletonList(this.key);
        this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(COMPARE_AND_DELETE, Long.class), keys, new Object[]{this.expectedValue});
    }

    public void close() throws Exception {
        this.unlock();
    }
}

