package cn.com.duiba.quanyi.center.api.dto.alipay;

import lombok.Data;

import java.io.Serializable;

@Data
public class StagedThresholdInfo implements Serializable {

    private static final long serialVersionUID = 6264355454392220249L;
    /**
     * 满足优惠的订单金额阈值最大值，单位为分
     */
    private Long maxThresholdAmount;

    /**
     * 满足优惠条件的订单金额最小值,分为单位
     */
    private Long minThresholdAmount;

    /**
     * 该区间范围内的定价优惠策略
     REDUCE_FIXED_AMOUNT：单笔固定立减
     REDUCE_TO_AMOUNT：减至优惠
     */
    private String priceCalcType;

    /**
     * 如果priceCalc=REDUCE_FIXED_AMOUNT，表示单笔立减5.55元；
     如果priceCalc=REDUCE_TO_AMOUNT，表示当前订单优惠到5.55元(即实际支付5.55元)
     */
    private Long reduceAmount;
}
