package cn.com.duiba.quanyi.center.api.dto.settlement;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单-商品明细
 * @author mybatis generator 
 * @date 2024-11-30
 */
@Data
public class SettlementGoodsDetailDto implements Serializable {
     
    private static final long serialVersionUID = 17329512198725585L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 商品明细唯一标记
     */
    private String uniqueMark;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 结算方式
     */
    private Integer settlementMethod;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 采购商品类型
     */
    private Integer purchaseSpuType;

    /**
     * 技术商品类型
     */
    private Integer spuType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 活动ID，默认-
     */
    private String thirdActivityId;

    /**
     * 活动名称，默认-
     */
    private String activityName;

    /**
     * 钱包号，默认-
     */
    private String walletNum;

    /**
     * 面额
     */
    private Long couponAmount;

    /**
     * 最小结算费率
     */
    private String minSettlementRate;

    /**
     * 最大结算费率
     */
    private String maxSettlementRate;

    /**
     * 最小结算价
     */
    private Long minSettlementPrice;

    /**
     * 最大结算价
     */
    private Long maxSettlementPrice;

    /**
     * 消耗数
     */
    private Long consumedNum;

    /**
     * 优惠金额
     */
    private Long discountAmount;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 天粒度与汇总粒度容差金额
     */
    private Long sumToleranceAmount;
}