package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2023/5/16 3:15 PM
 */
@Getter
@AllArgsConstructor
public enum BooleanEnum {
    FALSE(0, "否"),
    TRUE(1, "是"),
    ;
    private final Integer code;
    
    private final String desc;

    public static Integer booleanToEnum(boolean boo) {
        if (boo) {
            return BooleanEnum.TRUE.getCode();
        }
        return BooleanEnum.FALSE.getCode();
    }

    public static Boolean enumToBoolean(Integer code) {
        if (BooleanEnum.TRUE.getCode().equals(code)) {
            return true;
        }
        if (BooleanEnum.FALSE.getCode().equals(code)) {
            return false;
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        if (BooleanEnum.TRUE.getCode().equals(code)) {
            return BooleanEnum.TRUE.getDesc();
        }
        if (BooleanEnum.FALSE.getCode().equals(code)) {
            return BooleanEnum.FALSE.getDesc();
        }
        return null;
    }
}
