package cn.com.duiba.quanyi.center.api.enums.activity;

import cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 业务活动类型
 * 对应于领取记录表的类型
 *
 * @author zzy
 * @create 2023/10/11 11:32
 **/
@Getter
@AllArgsConstructor
public enum BizActTypeEnum {
    BAI_MING_DAN(1, "白名单领奖"),

    DUIBA_KAMI(2, "兑吧卡密包"),

    CCB_ZJ_PAY(3, "浙江建行支付"),

    CCB_ZJ_DING_TALK_NEW(4, "浙江建行-钉钉联合营销-新户"),

    CCB_ZJ_DING_TALK_OLD(5, "浙江建行-钉钉联合营销-老户"),

    GOODS_PKG(6, "权益卡券包"),

    API_SUPPLY(7, "API供货"),

    ICBC_JX(8, "江西权益领奖"),

    CCB_ZJ_ALIPAY_RED_ENVELOPE_COVER(9, "浙江建行-支付宝红包封面"),
    ICBC_GD_SPRING_FESTIVAL(10, "广东工行春节活动"),

    INSURANCE(11, "保司关联活动"),
    ICBC_SHAANXI(12, "陕西工行活动"),
    ICBC_XINJIANG(13, "新疆工行活动"),
    TEMPLATE_PROBABILITY(15, "模版活动-概率出奖"),
    TEMPLATE_DIRECT(16, "模版活动-直接出奖"),

    CCB_SICHUAN_HUIMEI(14,"建行四川分行惠美活动"),
    ALI_TRAVEL_ACTIVITY(17,"支付宝旅行活动"),
    MALL(18, "商城"),

    MINSHENG_PAY_ACTIVITY(19, "民生银行-特来电专区"),

    HZ_BANK_MALL(20,"杭州银行兑换活动"),

    API_SUPPLY_ACTIVITY(21, "API供货-活动"),

    TEMPLATE_PAY_STANDARD(23, "模版支付-达标发放活动"),

    CCB_ZJ_PAY_COUNT_COINS(24, "建行数币支付活动"),

    MINSHENG_AUDIOVISUAL_ACTIVITY(25, "民生银行-视听专区"),

    CMB_RED_COINS(26, "支付宝碰一下"),
    COLLECTION_PAGE(27, "集合页"),
    MULTI_CHOICE_ONE(28, "多选一集合页"),
    COMMON(29, "通用活动"),
    ;

    public static String getDescByType(Integer type) {
        for (BizActTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }

    private final Integer type;

    private final String desc;

    public static Integer getPayBizTypeByType(Integer type) {
        if (BAI_MING_DAN.type.equals(type)) {
            return PayBizTypeEnum.ACTIVITY_WHITELIST.getType();
        }
        if (CCB_SICHUAN_HUIMEI.type.equals(type)) {
            return PayBizTypeEnum.SICHUAN_HUIMEI_ACTIVITY.getType();
        }
        if (ALI_TRAVEL_ACTIVITY.type.equals(type)) {
            return PayBizTypeEnum.ALI_TRAVEL_PAY_ACTIVITY.getType();
        }
        if (MALL.type.equals(type)) {
            return PayBizTypeEnum.MALL.getType();
        }
        if (INSURANCE.type.equals(type)) {
            return PayBizTypeEnum.EQUITY_COUPON.getType();
        }
        if (MINSHENG_PAY_ACTIVITY.type.equals(type)) {
            return PayBizTypeEnum.MINSHENG_PAY_ACTIVITY.getType();
        }
        if (MINSHENG_AUDIOVISUAL_ACTIVITY.type.equals(type)) {
            return PayBizTypeEnum.MINSHENG_AUDIOVISUAL_ACTIVITY.getType();
        }
        if (DUIBA_KAMI.type.equals(type) || GOODS_PKG.type.equals(type)) {
            return PayBizTypeEnum.GOODS_PKG.getType();
        }
        if (HZ_BANK_MALL.type.equals(type)) {
            return PayBizTypeEnum.HZ_BANK_CREDITS_EXCHANGE_ACTIVITY.getType();
        }
        if (CCB_ZJ_PAY_COUNT_COINS.type.equals(type)) {
            return PayBizTypeEnum.CCB_COUNT_COINS.getType();
        }
        return null;
    }

    public static boolean isPkg(Integer type) {
        return DUIBA_KAMI.type.equals(type) || GOODS_PKG.type.equals(type);
    }
}
