package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同消耗类型
 * @author lizhi
 * @date 2023/8/7 16:34
 */
@Getter
@AllArgsConstructor
public enum ContractConsumeTypeEnum {
    //消耗类型, 1-框架，2-预算
    FRAMEWORK(1, "框架"),
    BUDGET(2, "预算"),
    ;
    
    private final Integer type;
    
    private final String desc;

    public static ContractConsumeTypeEnum getByType(Integer type) {
        for (ContractConsumeTypeEnum value : ContractConsumeTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

    public static String getDescByType(Integer type) {
        for (ContractConsumeTypeEnum value : ContractConsumeTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return null;
    }
}
