package cn.com.duiba.quanyi.center.api.enums.invoice;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/3 17:57
 */
@AllArgsConstructor
@Getter
public enum InvoiceApplyTaskTypeEnum {
    LOCK(1, "锁定"),
    UNLOCK(2, "解锁"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, InvoiceApplyTaskTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InvoiceApplyTaskTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InvoiceApplyTaskTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
