package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/11/25 16:23
 */
@AllArgsConstructor
@Getter
public enum SettlementLockStatusEnum {
    NOT_LOCKED(1, "未锁定"),
    LOCKED_IN(2, "锁定中"),
    LOCKED_SUCCESSFULLY(3, "锁定成功"),
    LOCK_FAILED(4, "锁定失败"),
    UNLOCKING_IN_PROGRESS(5, "解锁中"),
    UNLOCKED_SUCCESSFULLY(6, "解锁成功"),
    UNLOCK_FAILED(7, "解锁失败"),
    ;
    
    private final Integer status;
    
    private final String desc;

    /**
     * 结算单是否处于未锁单状态
     * @param status
     * @return
     */
    public static boolean unLocked(Integer status) {
        return NOT_LOCKED.getStatus().equals(status) || LOCK_FAILED.getStatus().equals(status)
                || UNLOCKED_SUCCESSFULLY.getStatus().equals(status);
    }
}
