package cn.com.duiba.quanyi.center.api.param.activity;

import java.io.Serializable;

import lombok.Data;

/**
 * 活动奖品排序参数
 *
 * @author yangyukang
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeSortParam implements Serializable {

    private static final long serialVersionUID = -6123789503728291267L;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 排序类型：
     * 1-上移
     * 2-下移
     * 3-置顶
     * 4-置底
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeSortTypeEnum
     */
    private Integer sortType;

    /**
     * 奖品类型，用于分类型排序，可为null
     */
    private Integer prizeType;
}