package cn.com.duiba.quanyi.center.api.param.demand;

import cn.com.duiba.quanyi.center.api.enums.DemandTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;
import java.util.Set;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DemandPageQueryParam extends PageQuery {
    
    private static final long serialVersionUID = 4015999495489693362L;
    
    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 客户id
     */
    private Long partnerId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 创建人id（条件）
     */
    private Long createPersonId;

    /**
     * 合同id
     */
    private Set<Long> contractIds;


    /**
     * 需求类型, 0-常规需求, 1-线下需求
     *
     * @see DemandTypeEnum
     */
    private Integer demandType;

    /**
     * 需求类型, 0-常规需求, 1-线下需求
     *
     * @see DemandTypeEnum
     */
    private Set<Integer> demandTypes;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 对接人ID数组
     */
    private List<Long> contactsIdList;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 项目id
     */
    private Set<Long> projectIds;

    /**
     * 采购状态
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PurchaseStatusEnum
     */
    private Integer purchaseStatus;

    /**
     * 采购状态
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PurchaseStatusEnum
     */
    private List<Integer> purchaseStatusList;
}
