package cn.com.duiba.quanyi.center.api.param.demandorder;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 需求单
 * @author mybatis generator 
 * @date 2025-05-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DemandOrderSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17471079463403792L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 需求兑吧主体id
     */
    private Long demandDuibaSubjectId;

    /**
     * 承接方兑吧主体id
     */
    private Long vendorDuibaSubjectId;

    /**
     * 客户主体名称 tb_partner.partner_subject
     */
    private String partnerSubjectName;

    /**
     * 需求开始日期
     */
    private Date demandStartDate;

    /**
     * 需求结束日期
     */
    private Date demandEndDate;

    /**
     * 需求单号
     */
    private String demandOrderNo;
}