package cn.com.duiba.quanyi.center.api.param.workflow;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/12/10 14:17
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkflowExecuteApprovalTaskParam implements Serializable {
    private static final long serialVersionUID = 8289991930913354270L;

    /**
     * 业务ID
     */
    @NotNull
    private Long bizId;

    /**
     * 审批类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     */
    @NotNull
    private Integer workflowType;

    /**
     * 操作人userId
     */
    @NotNull
    private String actionerUserId;

    /**
     * 审批意见 可为空
     */
    private String remark;

    /**
     * 审批操作，取值
     * agree: 同意
     * refuse: 拒绝
     */
    @NotNull
    private String result;

    /**
     * 任务id
     */
    @NotNull
    private Long taskId;
}
