package cn.com.duiba.quanyi.center.api.remoteservice.activity.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.take.ActivityCommonTakeResultDto;

/**
 * @author lizhi
 * @date 2025/5/20 13:41
 */
@AdvancedFeignClient
public interface RemoteActivityCommonTakeResultRedisService {

    /**
     * 查询领取结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param taskId 任务ID
     * @return 结果
     */
    BaseResultDto<ActivityCommonTakeResultDto> get(Long userId, Long activityId, String taskId);

    /**
     * 设置领取结果
     * @param userId 用户ID
     * @param activityId 活动ID
     * @param taskId 领取任务ID
     * @param dto 领取结果
     * @return 是否成功
     */
    boolean set(Long userId, Long activityId, String taskId, BaseResultDto<ActivityCommonTakeResultDto> dto);
}
