package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.DouYinCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinActivityBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinBindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinCouponPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.DouYinUpdateDeadlineParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteDouYinActivityCouponService {


    /**
     * 根据主键查询抖音支付券
     *
     * @param id
     * @return
     */
    DouYinCouponDto selectById(Long id);

    /**
     * 根据抖音活动id查询抖音支付券
     *
     * @param douyinActId 抖音活动id
     * @return
     */
    DouYinCouponDto selectByActId(String douyinActId);

    /**
     * 根据抖音活动id批量查询
     *
     * @param douyinActIds 活动id
     * @return 抖音支付券
     */
    List<DouYinCouponDto> selectByActIds(Set<String> douyinActIds);

    /**
     * 根据id批量查询
     *
     * @param idList
     * @return 抖音支付券 key = 主键，value = 抖音支付券信息
     */
    Map<Long, DouYinCouponDto> selectByIdList(Set<Long> idList);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<DouYinCouponDto> selectPage(DouYinCouponPageParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(DouYinCouponPageParam param);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(DouYinActivitySaveOrUpdateParam param);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(DouYinActivityBatchUpdateCreatorParam param);

    /**
     * 根据创建人查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 创建人数量
     */
    int selectCreatorCount(Long createOperatorId);


    /**
     * 根据需求商品id和 skuId查询
     *
     * @param demandGoodsId 需求商品 id
     * @param skuId         skuId
     * @return
     */
    List<DouYinCouponDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 根据需求id和 skuId查询
     *
     * @param demandId 需求 ID
     * @param skuId    sku ID
     * @return
     */
    List<DouYinCouponDto> selectByDemandSkuId(Long demandId, Long skuId);


    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<DouYinBindDemandGoodsParam> list);

    /**
     * 绑定需求商品
     *
     * @param param 绑定参数
     * @return 影响行数
     */
    int bindDemandGoods(DouYinBindDemandGoodsParam param);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId 需求商品ID
     * @return 抖音支付券列表
     */
    List<DouYinCouponDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据需求ID批量查询
     * @param demandIds 需求ID集合
     * @return 抖音支付券列表
     */
    List<Long> findCouponIdsByDemandIds(List<Long> demandIds);

    /**
     * 批次启用停用
     *
     * @param id 主键
     * @return 执行结果
     */
    int updateEnableStatus(Long id,Integer enableStatus);

    /**
     * 根据批次号ID更新结算天数
     * @param couponIdList 批次id集合
     * @param settlementDeadlineDays 退款结算日天数
     * @return 影响条数
     */
    int updateSettlementDeadlineDaysByIds(List<Long> couponIdList, Integer settlementDeadlineDays);

    /**
     * 根据批次号ID更新结算天数
     * @param param 更新参数
     * @return 影响条数
     */
    int updateSettlementDeadlineByParam(DouYinUpdateDeadlineParam param);
}
