package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxMchCodeGroupDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxMchCodeGroupSearchParam;
import java.util.List;

/**
 * 微信商户号组
 * @author kjj mybatis generator 
 * @date 2025-01-02
 */
@AdvancedFeignClient
public interface RemoteWxMchCodeGroupService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信商户号组集合
     */
    List<WxMchCodeGroupDto> selectPage(WxMchCodeGroupSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxMchCodeGroupSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信商户号组
     */
    WxMchCodeGroupDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信商户号组
     * @return 执行结果
     */
    int insert(WxMchCodeGroupDto dto);

    /**
     * 更新
     * @param dto 微信商户号组
     * @return 影响行数
     */
    int update(WxMchCodeGroupDto dto);

    /**
     * 更新启用状态
     *
     * @param id           主键id
     * @param enableStatus 启用状态
     * @return 执行结果
     */
    int updateEnableStatus(Long id, Integer enableStatus);
}