package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandGoodsQuantityChangeRecordDto;

/**
 * 需求商品数量变更记录表
 * @author kjj mybatis generator 
 * @date 2025-04-29
 */
@AdvancedFeignClient
public interface RemoteDemandGoodsQuantityChangeRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求商品数量变更记录
     */
    DemandGoodsQuantityChangeRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 需求商品数量变更记录
     * @return 执行结果
     */
    int insert(DemandGoodsQuantityChangeRecordDto dto);

    /**
     * 更新
     * @param dto 需求商品数量变更记录
     * @return 影响行数
     */
    int update(DemandGoodsQuantityChangeRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}