package cn.com.duiba.quanyi.center.api.remoteservice.holo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.holo.DownloadReportColumnDto;
import cn.com.duiba.quanyi.center.api.param.holo.DownloadReportColumnSearchParam;
import java.util.List;

/**
 * 下载报表列信息
 * @author kjj mybatis generator 
 * @date 2024-08-07
 */
@AdvancedFeignClient
public interface RemoteDownloadReportColumnService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 下载报列信息集合
     */
    List<DownloadReportColumnDto> selectPage(DownloadReportColumnSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DownloadReportColumnSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 下载报列信息
     */
    DownloadReportColumnDto selectById(Long id);

    /**
     * 新增
     * @param dto 下载报列信息
     * @return 执行结果
     */
    int insert(DownloadReportColumnDto dto);

    /**
     * 更新
     * @param dto 下载报列信息
     * @return 影响行数
     */
    int update(DownloadReportColumnDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据报表ID查询所有列信息
     * @param reportId
     * @return
     */
    List<DownloadReportColumnDto> selectColumnByReportId(Long reportId);
}