package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceCompanyFundSumStatisticsDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceFundAccountDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceCompanySearchParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceStatisticsSearchParam;

import java.util.List;

/**
 * 保司资金账户表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceFundAccountService {

    /**
     * 根据公司及手机号查询
     * @param companyId 保险公司ID，tb_insurance_company.id
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    InsuranceFundAccountDto selectByCompanyPhone(Long companyId, String accountPhone);

    /**
     * 创建资金账户
     * @param companyId
     * @param accountPhone
     * @return
     */
    InsuranceFundAccountDto saveIfAbsent(Long companyId, String accountPhone);

    /**
     * 根据手机号查询
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    List<InsuranceFundAccountDto> selectByPhone(String accountPhone);

    /**
     * 根据手机号查询选择的账户
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    InsuranceFundAccountDto selectSelectedByPhone(String accountPhone);

    /**
     * 选择公司
     *
     * @param accountPhone 手机号
     * @param companyId 保险公司ID，tb_insurance_company.id
     * @return 影响行数
     */
    int selectCompany(String accountPhone, Long companyId);

    /**
     * 公司维度汇总，总积分与消耗总积分
     * @param param
     * @return
     */
    List<InsuranceCompanyFundSumStatisticsDto> selectCompanyFundStatisticsPage(InsuranceStatisticsSearchParam param);


    /**
     * 公司维度汇总，总积分与消耗总积分
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCompanyFundStatisticsCount(InsuranceStatisticsSearchParam param);
}