package cn.com.duiba.quanyi.center.api.remoteservice.insurance.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceActivityTakeSplitDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeThresholdDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeRetryParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 保司权益兑换
 * @author lizhi
 * @date 2024/3/6 10:24
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeService {

    /**
     * 商品阈值
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return 结果
     */
    InsuranceTakeBaseResultDto<InsuranceTakeThresholdDto> threshold(Integer spuType);

    /**
     * 商品阈值
     * @return key：商品类型，value：结果
     */
    InsuranceTakeBaseResultDto<Map<Integer, InsuranceTakeThresholdDto>> allThreshold();

    /**
     * 拆分
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param companyId 公司ID
     * @param amount 金额
     * @return 拆分结果
     */
    InsuranceTakeBaseResultDto<List<InsuranceActivityTakeSplitDto>> split(Integer spuType, Long companyId, Long amount);

    /**
     * 提现时是否需要短信验证码
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return true-需要，false-不需要
     */
    InsuranceTakeBaseResultDto<Boolean> takeNeedSmsCode(Integer spuType);

    /**
     * 渠道当日已领取金额
     *
     * @param param 参数
     * @param now 当前时间
     * @return 金额
     */
    InsuranceTakeBaseResultDto<Long> sumDayChannelAmount(InsuranceTakeParam param, Date now);

    /**
     * 渠道当月已领取金额
     *
     * @param param 参数
     * @param now 当前时间
     * @return 金额
     */
    InsuranceTakeBaseResultDto<Long> sumMonthChannelAmount(InsuranceTakeParam param, Date now);

    /**
     * 兑换提交
     * @param param 兑换参数
     * @return 是否提交成功
     */
    boolean asyncTake(InsuranceTakeParam param);

    /**
     * 兑换提交结果
     * @param taskId 任务ID
     * @return 是否提交成功
     */
    InsuranceTakeBaseResultDto<String> takeResult(String taskId);

    /**
     * 重试
     * @param param 重试参数
     * @return 重试提交结果
     */
    GoodsOrderResultDto retry(InsuranceTakeRetryParam param);
}
